/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import se.trixon.almond.util.Log;
import se.trixon.almond.util.Xlog;

public class ProcessLogThread
extends Thread {
    private final int mChannel;
    private final InputStream mInputStream;
    private final Log mLog;

    public ProcessLogThread(InputStream inputStream, int channel, Log log) {
        this.mInputStream = inputStream;
        this.mChannel = channel;
        this.mLog = log;
    }

    @Override
    public void run() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.mInputStream), 1);
            while ((line = reader.readLine()) != null) {
                if (this.mChannel == 0) {
                    this.mLog.timedOut(line);
                    continue;
                }
                this.mLog.timedErr(line);
            }
        }
        catch (IOException e) {
            Xlog.timedErr(e.getLocalizedMessage());
        }
    }
}

