/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.control.Alert;
import javafx.stage.Window;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SnapHelper;
import se.trixon.almond.util.fx.dialogs.OptionalDialog;

public class SnapHelperFx {
    public static void checkSnapStatus(Class cls, String id, Window window, String snapName, String ... plugsAndSlots) {
        try {
            if (SnapHelper.isSnap()) {
                StringBuilder sb = new StringBuilder();
                for (String plugsAndSlot : plugsAndSlots) {
                    if (SnapHelper.isConnected(plugsAndSlot)) continue;
                    sb.append("sudo snap connect %s:%s\n".formatted(snapName, plugsAndSlot));
                }
                if (sb.length() > 0) {
                    String message = "For a better experience, consider executing:\n\n" + sb.toString() + "\nor through the Permissions UI in the snap-store application.";
                    OptionalDialog.requestShowDialog(cls, id, Alert.AlertType.INFORMATION, window, Dict.INFORMATION.toString(), "It looks like you are running '%s' as a snap".formatted(snapName), message, null);
                }
            }
        }
        catch (IOException | InterruptedException ex) {
            Logger.getLogger(cls.getName()).log(Level.SEVERE, null, ex);
            Thread.currentThread().interrupt();
        }
    }
}

