/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;
import oshi.util.FormatUtil;
import se.trixon.almond.util.SystemHelper;

public class SystemInformation {
    private String mData;

    public static void main(String[] args) {
        SystemInformation si = new SystemInformation();
        System.out.println(si.generateSystemInformation());
    }

    public void copy() {
        SystemHelper.copyToClipboard(this.mData);
    }

    public String generateSystemInformation() {
        SystemInfo systemInfo = new SystemInfo();
        HardwareAbstractionLayer hw = systemInfo.getHardware();
        OperatingSystem os = systemInfo.getOperatingSystem();
        ArrayList<String> hwItems = new ArrayList<String>();
        hwItems.add("%s %s (%s)".formatted(hw.getComputerSystem().getManufacturer(), hw.getComputerSystem().getModel(), FormatUtil.formatHertz((long)hw.getProcessor().getMaxFreq())));
        hwItems.add(hw.getProcessor().getProcessorIdentifier().getName());
        hwItems.add(hw.getProcessor().getProcessorIdentifier().getIdentifier());
        hw.getGraphicsCards().forEach(graphicsCard -> hwItems.add("%s %s".formatted(graphicsCard.getName(), graphicsCard.getVendor())));
        hw.getDiskStores().forEach(diskStore -> hwItems.add(diskStore.toString()));
        hwItems.add(hw.getMemory().toString());
        hwItems.add(hw.getMemory().getVirtualMemory().toString());
        ArrayList<String> osItems = new ArrayList<String>();
        osItems.add(os.toString());
        StringBuilder sb = new StringBuilder();
        sb.append(">HARDWARE").append("\n");
        sb.append(String.join((CharSequence)"\n", hwItems));
        sb.append("\n\n>OS").append("\n");
        sb.append(String.join((CharSequence)"\n", osItems));
        sb.append("\n\n>ENV").append("\n");
        sb.append(String.join((CharSequence)"\n", this.getSystemProperties()));
        this.mData = sb.toString();
        return this.mData;
    }

    private ArrayList<String> getSystemProperties() {
        String[] keys = new String[]{"user.country", "user.home", "user.language", "user.name", "user.timezone", "", "os.arch", "os.name", "os.version", "", "file.encoding.pkg", "file.encoding", "file.separator", "path.separator", "", "netbeans.home", "netbeans.user", "netbeans.dirs", "netbeans.running.environment", "netbeans.productversion", "netbeans.buildnumber", "netbeans.dynamic.classpath", "netbeans.logger.console", "", "java.awt.graphicsenv", "java.awt.printerjob", "java.class.path", "java.class.version", "java.endorsed.dirs", "java.ext.dirs", "java.home", "java.io.tmpdir", "java.library.path", "java.runtime.name", "java.runtime.version", "java.specification.name", "java.specification.vendor", "java.specification.version", "java.vendor", "java.vendor.url.bug", "java.vendor.url", "java.version", "java.vm.info", "java.vm.name", "java.vm.specification.name", "java.vm.specification.vendor", "java.vm.specification.version", "java.vm.vendor", "java.vm.version", "", "sun.arch.data.model", "sun.boot.class.path", "sun.boot.library.path", "sun.cpu.endian", "sun.cpu.isalist", "sun.io.unicode.encoding", "sun.java.launcher", "sun.jnu.encoding", "sun.management.compiler", "sun.os.patch.level"};
        int len = 2;
        for (String key : keys) {
            len = Math.max(len, key.length());
        }
        ArrayList<String> envItems = new ArrayList<String>();
        Properties p = System.getProperties();
        for (String key : keys) {
            if (StringUtils.isBlank((CharSequence)key)) {
                envItems.add("");
                continue;
            }
            if (!p.containsKey(key)) continue;
            envItems.add(StringUtils.rightPad((String)key, (int)len) + p.getProperty(key, ""));
        }
        return envItems;
    }
}

