/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util;

import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class Xlog {
    public static final int ASSERT = 7;
    public static final int DEBUG = 3;
    public static final int ERROR = 6;
    public static final int INFO = 4;
    public static final int VERBOSE = 2;
    public static final int WARN = 5;
    public static String sGlobalTag = "";
    private static boolean sActive = true;
    private static DateTimeFormatter sDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH.mm.ss: ");
    private static int sLevel = 2;
    private static boolean sUseGlobalTag = false;
    private static boolean sUseTimestamps = true;

    public static synchronized void a(Class c, String msg) {
        Xlog.a(Xlog.getTag(c.getCanonicalName()), msg);
    }

    public static synchronized void a(String tag, String msg) {
        if (sActive && sLevel <= 7) {
            Xlog.printErr("ASSERT", Xlog.getMessage(Xlog.getTag(tag), Xlog.getNullSafeMsg(msg)));
        }
    }

    public static synchronized void d(Class c, String msg) {
        Xlog.d(Xlog.getTag(c.getCanonicalName()), msg);
    }

    public static synchronized void d(String tag, String msg) {
        if (sActive && sLevel <= 3) {
            Xlog.print("DEBUG", Xlog.getMessage(Xlog.getTag(tag), Xlog.getNullSafeMsg(msg)));
        }
    }

    public static synchronized void e(Class c, String msg) {
        Xlog.e(Xlog.getTag(c.getCanonicalName()), msg);
    }

    public static synchronized void e(String tag, String msg) {
        if (sActive && sLevel <= 6) {
            Xlog.printErr("ERROR", Xlog.getMessage(Xlog.getTag(tag), Xlog.getNullSafeMsg(msg)));
        }
    }

    public static synchronized String getGlobalTag() {
        return sGlobalTag;
    }

    public static synchronized int getLevel() {
        return sLevel;
    }

    public static synchronized void i(Class c, String msg) {
        Xlog.i(Xlog.getTag(c.getCanonicalName()), msg);
    }

    public static synchronized void i(String tag, String msg) {
        if (sActive && sLevel <= 4) {
            Xlog.print("INFO", Xlog.getMessage(Xlog.getTag(tag), Xlog.getNullSafeMsg(msg)));
        }
    }

    public static synchronized boolean isActive() {
        return sActive;
    }

    public static synchronized boolean isUseGlobalTag() {
        return sUseGlobalTag;
    }

    public static synchronized boolean isUseTimestamps() {
        return sUseTimestamps;
    }

    public static synchronized void setActive(boolean active) {
        sActive = active;
    }

    public static synchronized void setGlobalTag(String globalTag) {
        sGlobalTag = globalTag;
    }

    public static synchronized void setLevel(int level) {
        sLevel = level;
    }

    public static synchronized void setUseGlobalTag(boolean useGlobalTag) {
        sUseGlobalTag = useGlobalTag;
    }

    public static synchronized void timedErr(String message) {
        Xlog.printDate(System.err);
        System.err.println(message);
    }

    public static synchronized void timedOut(String message) {
        Xlog.printDate(System.out);
        System.out.println(message);
    }

    public static synchronized void v(Class<?> c, String msg) {
        Xlog.v(Xlog.getTag(c.getCanonicalName()), msg);
    }

    public static synchronized void v(String tag, String msg) {
        if (sActive && sLevel <= 2) {
            Xlog.print("VERBOSE", Xlog.getMessage(Xlog.getTag(tag), Xlog.getNullSafeMsg(msg)));
        }
    }

    public static synchronized void w(Class c, String msg) {
        Xlog.w(Xlog.getTag(c.getCanonicalName()), msg);
    }

    public static synchronized void w(String tag, String msg) {
        if (sActive && sLevel <= 5) {
            Xlog.printErr("WARNING", Xlog.getMessage(Xlog.getTag(tag), Xlog.getNullSafeMsg(msg)));
        }
    }

    private static String getMessage(String s1, String s2) {
        return "[%s] %s".formatted(s1, s2);
    }

    private static String getMessage(String s1, String s2, String s3) {
        return "[%s] [%s] %s".formatted(s1, s2, s3);
    }

    private static String getNullSafeMsg(String msg) {
        if (msg == null) {
            return "NULL";
        }
        return msg;
    }

    private static String getTag(String localTag) {
        String tag = sUseGlobalTag ? sGlobalTag : localTag;
        return tag;
    }

    private static void print(String levelClass, String message) {
        Xlog.printDate(System.out);
        System.out.println("%s %s".formatted(levelClass, message));
    }

    private static void printDate(PrintStream printStream) {
        if (sUseTimestamps) {
            printStream.print(LocalDateTime.now().format(sDateTimeFormatter));
        }
    }

    private static void printErr(String levelClass, String message) {
        Xlog.printDate(System.err);
        System.out.println("%s %s".formatted(levelClass, message));
    }
}

