/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.fx.control;

import java.time.LocalDate;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.DateCell;
import javafx.scene.control.DatePicker;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.Callback;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.fx.control.DateRangeSlider;
import se.trixon.almond.util.fx.control.DateSelectionMode;
import se.trixon.almond.util.fx.control.DateSlider;

public class DatePane
extends GridPane {
    private DateRangeSlider mDateRangeSlider;
    private DateSelectionMode mDateSelectionMode;
    private DateSlider mDateSlider;
    private DatePicker mFromDatePicker;
    private DatePicker mToDatePicker;

    public DatePane() {
        this.createUI();
    }

    public void addFromDatePickerListener(ChangeListener<Object> changeListener) {
        this.mFromDatePicker.valueProperty().addListener(changeListener);
    }

    public void addToDatePickerListener(ChangeListener<Object> changeListener) {
        this.mToDatePicker.valueProperty().addListener(changeListener);
    }

    public DateRangeSlider getDateRangeSlider() {
        return this.mDateRangeSlider;
    }

    public DateSelectionMode getDateSelectionMode() {
        return this.mDateSelectionMode;
    }

    public DatePicker getFromDatePicker() {
        return this.mFromDatePicker;
    }

    public DatePicker getToDatePicker() {
        return this.mToDatePicker;
    }

    public void setDateSelectionMode(DateSelectionMode dateSelectionMode) {
        this.mDateSelectionMode = dateSelectionMode;
        this.getChildren().removeAll((Object[])new Node[]{this.mDateSlider, this.mDateRangeSlider});
        this.addRow(0, new Node[]{dateSelectionMode == DateSelectionMode.INTERVAL ? this.mDateRangeSlider : this.mDateSlider});
        this.mToDatePicker.setDisable(dateSelectionMode == DateSelectionMode.POINT_IN_TIME);
        if (dateSelectionMode == DateSelectionMode.INTERVAL) {
            this.mDateSlider.dateProperty().unbindBidirectional((Property)this.mFromDatePicker.valueProperty());
            this.mDateSlider.dateProperty().unbindBidirectional((Property)this.mToDatePicker.valueProperty());
            this.mDateRangeSlider.lowDateProperty().bindBidirectional((Property)this.mFromDatePicker.valueProperty());
            this.mDateRangeSlider.highDateProperty().bindBidirectional((Property)this.mToDatePicker.valueProperty());
        } else {
            this.mDateRangeSlider.lowDateProperty().unbindBidirectional((Property)this.mFromDatePicker.valueProperty());
            this.mDateRangeSlider.highDateProperty().unbindBidirectional((Property)this.mToDatePicker.valueProperty());
            this.mDateSlider.dateProperty().bindBidirectional((Property)this.mToDatePicker.valueProperty());
            this.mDateSlider.dateProperty().bindBidirectional((Property)this.mFromDatePicker.valueProperty());
        }
    }

    public void setMinMaxDate(final LocalDate minDate, final LocalDate maxDate) {
        this.mDateSlider.setMinMaxDate(minDate, maxDate);
        this.mDateRangeSlider.setMinMaxDate(minDate, maxDate);
        Callback selectionLimiter = d -> new DateCell(){

            public void updateItem(LocalDate localDate, boolean empty) {
                super.updateItem(localDate, empty);
                this.setDisable(localDate.isAfter(maxDate) || localDate.isBefore(minDate));
            }
        };
        this.mFromDatePicker.setDayCellFactory(selectionLimiter);
        this.mToDatePicker.setDayCellFactory(selectionLimiter);
    }

    private void createUI() {
        this.mDateRangeSlider = new DateRangeSlider();
        this.mDateRangeSlider.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        GridPane.setColumnSpan((Node)this.mDateRangeSlider, (Integer)Integer.MAX_VALUE);
        this.mDateSlider = new DateSlider();
        this.mDateSlider.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        GridPane.setColumnSpan((Node)this.mDateSlider, (Integer)Integer.MAX_VALUE);
        this.mFromDatePicker = new DatePicker();
        this.mFromDatePicker.setValue((Object)LocalDate.of(1900, 1, 1));
        this.mFromDatePicker.setEditable(false);
        GridPane.setFillWidth((Node)this.mFromDatePicker, (Boolean)true);
        GridPane.setHgrow((Node)this.mFromDatePicker, (Priority)Priority.ALWAYS);
        this.mToDatePicker = new DatePicker();
        this.mToDatePicker.setValue((Object)LocalDate.of(2099, 12, 31));
        this.mToDatePicker.setEditable(false);
        GridPane.setFillWidth((Node)this.mToDatePicker, (Boolean)true);
        GridPane.setHgrow((Node)this.mToDatePicker, (Priority)Priority.ALWAYS);
        FxHelper.setMargin(new Insets(8.0, 0.0, 0.0, 0.0), new Region[]{this.mFromDatePicker});
        FxHelper.setMargin(new Insets(8.0, 0.0, 0.0, 8.0), new Region[]{this.mToDatePicker});
        this.setPadding(new Insets(8.0));
        this.addRow(1, new Node[]{this.mFromDatePicker, this.mToDatePicker});
        this.setDateSelectionMode(DateSelectionMode.INTERVAL);
    }
}

