/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.fx.control;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Slider;
import org.apache.commons.lang3.ObjectUtils;

public class DateSlider
extends Slider {
    private final SimpleObjectProperty<LocalDate> mDateProperty = new SimpleObjectProperty();
    private final SimpleObjectProperty<LocalDate> mMaxDateProperty = new SimpleObjectProperty();
    private final SimpleObjectProperty<LocalDate> mMinDateProperty = new SimpleObjectProperty();

    public DateSlider() {
        this.init();
        this.initListeners();
    }

    public SimpleObjectProperty<LocalDate> dateProperty() {
        return this.mDateProperty;
    }

    public LocalDate getDate() {
        return (LocalDate)this.mDateProperty.getValue();
    }

    public LocalDate getMaxDate() {
        return (LocalDate)this.mMaxDateProperty.getValue();
    }

    public LocalDate getMinDate() {
        return (LocalDate)this.mMinDateProperty.getValue();
    }

    public SimpleObjectProperty<LocalDate> maxDateProperty() {
        return this.mMaxDateProperty;
    }

    public SimpleObjectProperty<LocalDate> minDateProperty() {
        return this.mMinDateProperty;
    }

    public void setDate(LocalDate localDate) {
        this.mDateProperty.setValue((Object)localDate);
    }

    public void setMaxDate(LocalDate localDate) {
        this.mMaxDateProperty.setValue((Object)localDate);
    }

    public void setMinDate(LocalDate localDate) {
        this.mMinDateProperty.setValue((Object)localDate);
    }

    public void setMinMaxDate(LocalDate minDate, LocalDate maxDate) {
        this.mMinDateProperty.setValue((Object)minDate);
        this.mMaxDateProperty.setValue((Object)maxDate);
        this.mDateProperty.setValue((Object)maxDate);
        this.setMin(0.0);
        if (ObjectUtils.allNotNull((Object[])new Object[]{minDate, maxDate})) {
            this.setMax(ChronoUnit.DAYS.between(minDate, maxDate));
        }
        this.setValue(this.getMin());
    }

    private void init() {
        this.setMajorTickUnit(7.0);
        this.setMinorTickCount(1);
    }

    private void initListeners() {
        this.valueProperty().addListener((ov, t, t1) -> this.dateProperty().setValue((Object)this.getMinDate().plusDays(t1.intValue())));
        this.dateProperty().addListener((ov, t, t1) -> {
            if (this.getMaxDate() != null) {
                this.setValue(ChronoUnit.DAYS.between(this.getMinDate(), (Temporal)t1));
            }
        });
    }
}

