/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.fx.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.util.StringConverter;

public class LocaleComboBox
extends ComboBox<Locale> {
    public LocaleComboBox() {
        this.init();
    }

    private void init() {
        ObservableList data = FXCollections.observableArrayList();
        ArrayList<Locale> locales = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
        locales.sort((o1, o2) -> o1.getDisplayName().compareTo(o2.getDisplayName()));
        final HashMap displayNameToLocale = new HashMap();
        locales.forEach(locale -> {
            data.add(locale);
            displayNameToLocale.put(locale.getDisplayName(), locale);
        });
        this.setItems(data);
        this.setValue(Locale.getDefault());
        StringConverter<Locale> converter = new StringConverter<Locale>(){

            public Locale fromString(String string) {
                return (Locale)displayNameToLocale.get(string);
            }

            public String toString(Locale locale) {
                return locale.getDisplayName();
            }
        };
        this.setConverter((StringConverter)converter);
    }
}

