/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.fx.dialogs;

import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Dialog;
import javafx.stage.Stage;
import javafx.stage.Window;
import se.trixon.almond.util.fx.FxHelper;

public class Message {
    public static void error(Window owner, String title, String headerText, String contentText) {
        Message.display(Alert.AlertType.ERROR, owner, title, headerText, contentText);
    }

    public static void error(Node node, String title, String headerText, String contentText) {
        Message.display(Alert.AlertType.ERROR, node, title, headerText, contentText);
    }

    public static void information(Node node, String title, String headerText, String contentText) {
        Message.display(Alert.AlertType.INFORMATION, node, title, headerText, contentText);
    }

    public static void information(Window owner, String title, String headerText, String contentText) {
        Message.display(Alert.AlertType.INFORMATION, owner, title, headerText, contentText);
    }

    public static void none(Node node, String title, String headerText, String contentText) {
        Message.display(Alert.AlertType.NONE, node, title, headerText, contentText);
    }

    public static void none(Window owner, String title, String headerText, String contentText) {
        Message.display(Alert.AlertType.NONE, owner, title, headerText, contentText);
    }

    public static void warning(Node node, String title, String headerText, String contentText) {
        Message.display(Alert.AlertType.WARNING, node, title, headerText, contentText);
    }

    public static void warning(Window owner, String title, String headerText, String contentText) {
        Message.display(Alert.AlertType.WARNING, owner, title, headerText, contentText);
    }

    private static void display(Alert.AlertType alertType, Node node, String title, String headerText, String contentText) {
        Window owner = null;
        try {
            owner = node.getScene().getWindow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Message.display(alertType, owner, title, headerText, contentText);
    }

    private static void display(Alert.AlertType alertType, Window owner, String title, String headerText, String contentText) {
        Alert alert = new Alert(alertType);
        alert.initOwner(owner);
        if (title != null) {
            alert.setTitle(title);
        }
        alert.setHeaderText(headerText);
        alert.setContentText(contentText);
        FxHelper.showAndWait((Dialog)alert, (Stage)owner);
    }
}

