/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.fx.dialogs.about;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.AboutModel;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.dialogs.about.BaseListTab;

public class LibrariesTab
extends BaseListTab {
    private final ArrayList<String> mLibraries = new ArrayList();

    public LibrariesTab(AboutModel aboutModel) {
        super(aboutModel, Dict.LIBRARIES.toString());
        this.init();
    }

    private void init() {
        String javaVersion = System.getProperty("java.runtime.version");
        String javaName = System.getProperty("java.runtime.name");
        String java = "%s %s".formatted(javaName, javaVersion);
        this.mLibraries.add(java);
        ArrayList<String> libraries = new ArrayList<String>();
        libraries.add("Almond-Util");
        if (this.mAboutModel.getLibraries() != null) {
            String[] libs = StringUtils.split((String)this.mAboutModel.getLibraries(), (String)";");
            libraries.addAll(Arrays.asList(libs));
        }
        libraries.sort((o1, o2) -> o1.compareToIgnoreCase((String)o2));
        this.mLibraries.addAll(libraries);
        StringBuilder builder = new StringBuilder("\n");
        this.mLibraries.forEach(library -> builder.append("  \u25cf ").append((String)library).append("\n"));
        this.mTextArea.setText(builder.toString());
    }
}

