/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.icons.material;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

class GenerateMaterial {
    private static final String DIR_DEST = "/home/pata/temp/material";
    private static final String DIR_SOURCE = "/home/pata/temp/material-design-icons-3.0.1";

    public static void main(String[] args) {
        try {
            new GenerateMaterial();
        }
        catch (IOException ex) {
            Logger.getLogger(GenerateMaterial.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public GenerateMaterial() throws IOException {
        File rootDir = new File(DIR_SOURCE);
        File destDir = new File(DIR_DEST);
        StringBuilder builder = new StringBuilder();
        this.addHeader(builder);
        FileVisitor fileVisitor = new FileVisitor(destDir);
        EnumSet<FileVisitOption> fileVisitOptions = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(rootDir.toPath(), fileVisitOptions, Integer.MAX_VALUE, fileVisitor);
        fileVisitor.addEnums(builder);
        this.addFooter(builder);
        System.out.println(builder.toString());
    }

    private void addHeader(StringBuilder builder) {
        builder.append("package se.trixon.almond.util.icons.material;").append("\n");
        builder.append("import java.awt.Image;").append("\n");
        builder.append("import java.awt.image.BufferedImage;").append("\n");
        builder.append("import java.io.IOException;").append("\n");
        builder.append("import java.util.logging.Level;").append("\n");
        builder.append("import java.util.logging.Logger;").append("\n");
        builder.append("import javafx.embed.swing.SwingFXUtils;").append("\n");
        builder.append("import javafx.scene.image.ImageView;").append("\n");
        builder.append("import javax.imageio.ImageIO;").append("\n");
        builder.append("import javax.swing.ImageIcon;").append("\n");
        builder.append("import se.trixon.almond.util.GraphicsHelper;").append("\n");
        builder.append("import se.trixon.almond.util.fx.FxHelper;").append("\n");
        builder.append("import se.trixon.almond.util.icons.IconColor;").append("\n");
        builder.append("public class MaterialIcon {").append("\n");
        builder.append("    private static javafx.scene.paint.Color sDefaultColor=javafx.scene.paint.Color.BLACK;\n\n    public static javafx.scene.paint.Color getDefaultColor() {\n        return sDefaultColor;\n    }\n\n    public static void setDefaultColor(javafx.scene.paint.Color color) {\n        sDefaultColor = color;\n    }\n");
        builder.append("\n");
        builder.append("    private static BufferedImage getBufferedImage(String dir, String baseName, int size, java.awt.Color color) {\n        BufferedImage bi = null;\n\n        try {\n            bi = ImageIO.read(MaterialIcon.class.getResource(\"%s/%s_white.png\".formatted(dir, baseName.toLowerCase())));\n            bi = GraphicsHelper.toBufferedImage(bi.getScaledInstance(size, size, Image.SCALE_SMOOTH));\n            bi = GraphicsHelper.colorize(bi, color);\n        } catch (IOException ex) {\n            Logger.getLogger(MaterialIcon.class.getName()).log(Level.SEVERE, null, ex);\n        }\n\n        return bi;\n    }\n");
        builder.append("\n");
        builder.append("    private static ImageIcon getImageIcon(String dir, String baseName, int size, java.awt.Color color) {\n        BufferedImage bufferedImage = getBufferedImage(dir, baseName, size, color);\n        return new ImageIcon(bufferedImage);\n    }\n");
        builder.append("\n");
        builder.append("    private static ImageView getImageView(String dir, String baseName, int size, javafx.scene.paint.Color color) {\n        BufferedImage bufferedImage = getBufferedImage(dir, baseName, size, FxHelper.colorToColor(color));\n\n        return new ImageView(SwingFXUtils.toFXImage(bufferedImage, null));\n    }\n");
        builder.append("\n");
    }

    private void addFooter(StringBuilder builder) {
        builder.append("public interface IconGetter{").append("\n");
        builder.append("public ImageIcon getImageIcon(int size, java.awt.Color color);").append("\n");
        builder.append("public ImageIcon getImageIcon(int size);").append("\n");
        builder.append("public ImageView getImageView(int size, javafx.scene.paint.Color color);").append("\n");
        builder.append("public ImageView getImageView(int size);").append("\n");
        builder.append("}").append("\n");
        builder.append("").append("\n");
        builder.append("}").append("\n");
    }

    class FileVisitor
    extends SimpleFileVisitor<Path> {
        private final File mDestDir;
        private boolean mInterrupted;
        private String mCategory;
        private final Set<String> mEnums = new TreeSet<String>();
        private String mOverride = "@Override";

        public FileVisitor(File destDir) {
            this.mDestDir = destDir;
        }

        public void addEnums(StringBuilder builder) {
            this.mEnums.forEach(enumItem -> builder.append((String)enumItem));
        }

        public boolean isInterrupted() {
            return this.mInterrupted;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (Thread.interrupted()) {
                this.mInterrupted = true;
                return FileVisitResult.TERMINATE;
            }
            if (dir.toString().contains("2x_web")) {
                this.mCategory = dir.getParent().getFileName().toString();
                StringBuilder builder = new StringBuilder();
                builder.append("public enum _%s implements IconGetter{".formatted(StringUtils.capitalize((String)this.mCategory.toLowerCase()))).append("\n");
                File categoryDir = new File(this.mDestDir, "_" + this.mCategory);
                FileUtils.forceMkdir((File)categoryDir);
                String[] filePaths = dir.toFile().list();
                if (filePaths != null && filePaths.length > 0) {
                    TreeSet<Object> treeSet = new TreeSet<Object>();
                    for (String fileName : filePaths) {
                        File file = new File(dir.toFile(), fileName);
                        Object name2 = file.getName().toLowerCase();
                        if (!((String)name2).endsWith("_48dp.png")) continue;
                        if (StringUtils.isNumeric((CharSequence)StringUtils.left((String)(name2 = ((String)name2).replace("ic_", "").replace("_48dp.png", ".png")), (int)1))) {
                            name2 = "_" + (String)name2;
                        }
                        FileUtils.copyFile((File)file, (File)new File(categoryDir, (String)name2), (boolean)true);
                        name2 = ((String)name2).replace("_black", "").replace("_white", "").replace(".png", "");
                        treeSet.add(name2);
                    }
                    treeSet.forEach(name -> builder.append(name.toUpperCase()).append(",").append("\n"));
                    builder.deleteCharAt(builder.length() - 1);
                    builder.deleteCharAt(builder.length() - 1);
                    builder.append(";").append("\n");
                    builder.append(this.mOverride).append("\n");
                    builder.append("public ImageIcon getImageIcon(int size, java.awt.Color color) {").append("\n");
                    builder.append("return MaterialIcon.getImageIcon(getClass().getSimpleName().toLowerCase(), name(), size, color);").append("\n");
                    builder.append("}").append("\n");
                    builder.append(this.mOverride).append("\n");
                    builder.append("public ImageIcon getImageIcon(int size) {").append("\n");
                    builder.append("return MaterialIcon.getImageIcon(getClass().getSimpleName().toLowerCase(), name(), size, FxHelper.colorToColor(getDefaultColor()));").append("\n");
                    builder.append("}").append("\n");
                    builder.append(this.mOverride).append("\n");
                    builder.append("public ImageView getImageView(int size, javafx.scene.paint.Color color) {").append("\n");
                    builder.append("return MaterialIcon.getImageView(getClass().getSimpleName().toLowerCase(), name(), size, color);").append("\n");
                    builder.append("}").append("\n");
                    builder.append(this.mOverride).append("\n");
                    builder.append("public ImageView getImageView(int size) {").append("\n");
                    builder.append("return MaterialIcon.getImageView(getClass().getSimpleName().toLowerCase(), name(), size, getDefaultColor());").append("\n");
                    builder.append("}").append("\n");
                }
                builder.append("}").append("\n");
                this.mEnums.add(builder.toString());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }
}

