/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.io;

import java.util.Locale;
import se.trixon.almond.util.MathHelper;
import se.trixon.almond.util.io.CoordinateFormat;

public class CoordinatePoint {
    private static int DECIMALS_X = 3;
    private static int DECIMALS_Y = 3;
    private static int DECIMALS_Z = 3;
    protected Double mX;
    protected String mXRaw;
    protected Double mY;
    protected String mYRaw;
    protected Double mZ;
    protected String mZRaw;

    public static int getDecimalsX() {
        return DECIMALS_X;
    }

    public static int getDecimalsY() {
        return DECIMALS_Y;
    }

    public static int getDecimalsZ() {
        return DECIMALS_Z;
    }

    public static void setDecimalsX(int decimals) {
        DECIMALS_X = decimals;
    }

    public static void setDecimalsY(int decimals) {
        DECIMALS_Y = decimals;
    }

    public static void setDecimalsZ(int decimals) {
        DECIMALS_Z = decimals;
    }

    public String getX(CoordinateFormat coordinateFormat) {
        switch (coordinateFormat) {
            case FORMATTED: {
                return this.getXFormatted();
            }
            case RAW: {
                return this.getXRaw();
            }
        }
        return MathHelper.convertDoubleToString(this.getX());
    }

    public Double getX() {
        return this.mX;
    }

    public String getXFormatted() {
        return this.getXFormatted(Locale.ENGLISH);
    }

    public String getXFormatted(Locale locale) {
        return MathHelper.convertDoubleToString(locale, this.getX(), CoordinatePoint.getDecimalsX());
    }

    public String getXRaw() {
        return this.mXRaw;
    }

    public String getY(CoordinateFormat coordinateFormat) {
        switch (coordinateFormat) {
            case FORMATTED: {
                return this.getYFormatted();
            }
            case RAW: {
                return this.getYRaw();
            }
        }
        return MathHelper.convertDoubleToString(this.getY());
    }

    public Double getY() {
        return this.mY;
    }

    public String getYFormatted() {
        return this.getYFormatted(Locale.ENGLISH);
    }

    public String getYFormatted(Locale locale) {
        return MathHelper.convertDoubleToString(locale, this.getY(), CoordinatePoint.getDecimalsY());
    }

    public String getYRaw() {
        return this.mYRaw;
    }

    public String getZ(CoordinateFormat coordinateFormat) {
        switch (coordinateFormat) {
            case FORMATTED: {
                return this.getZFormatted();
            }
            case RAW: {
                return this.getZRaw();
            }
        }
        return MathHelper.convertDoubleToString(this.getZ());
    }

    public Double getZ() {
        return this.mZ;
    }

    public String getZFormatted() {
        return this.getZFormatted(Locale.ENGLISH);
    }

    public String getZFormatted(Locale locale) {
        return MathHelper.convertDoubleToString(locale, this.getZ(), CoordinatePoint.getDecimalsZ());
    }

    public String getZRaw() {
        return this.mZRaw;
    }

    public void setX(Double value) {
        this.mX = value;
        this.mXRaw = MathHelper.convertDoubleToString(Locale.ENGLISH, value);
    }

    public void setXRaw(String raw) {
        this.mXRaw = raw;
        this.mX = MathHelper.convertStringToDouble(raw);
    }

    public void setY(Double value) {
        this.mY = value;
        this.mYRaw = MathHelper.convertDoubleToString(Locale.ENGLISH, value);
    }

    public void setYRaw(String raw) {
        this.mYRaw = raw;
        this.mY = MathHelper.convertStringToDouble(raw);
    }

    public void setZ(Double value) {
        this.mZ = value;
        this.mZRaw = MathHelper.convertDoubleToString(Locale.ENGLISH, value);
    }

    public void setZRaw(String raw) {
        this.mZRaw = raw;
        this.mZ = MathHelper.convertStringToDouble(raw);
    }
}

