/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.io;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.io.Geo;
import se.trixon.almond.util.io.GeoHelper;
import se.trixon.almond.util.io.GeoPoint;

public class GeoLine {
    private LinkedHashMap<String, String> mAttributes = new LinkedHashMap();
    private String mClosedPolygon = "";
    private String mCode = "";
    private String mLineNumber = "";
    private LinkedList<GeoPoint> mPoints = new LinkedList();
    private transient Geo mGeo;

    public GeoLine() {
    }

    public GeoLine(LinkedList<String> section) {
        this(section.pollFirst());
        if (!section.isEmpty()) {
            section.pollFirst();
            section.pollLast();
            if (section.size() == 1) {
                section.add("begin");
                section.add("end");
            }
            this.mPoints.addAll(GeoHelper.parsePointList(this, section));
        }
    }

    public GeoLine(String line) {
        line = StringUtils.removeStart((String)line.trim(), (String)"Line");
        String[] segments = StringUtils.splitPreserveAllTokens((String)line.trim(), (String)",");
        this.mLineNumber = StringUtils.remove((String)segments[0], (String)"\"");
        this.mClosedPolygon = StringUtils.trim((String)segments[1]);
        this.mCode = StringUtils.remove((String)segments[2], (String)"\"");
    }

    public LinkedHashMap<String, String> getAttributes() {
        return this.mAttributes;
    }

    public String getCode() {
        return this.mCode;
    }

    public String getLineNumber() {
        return this.mLineNumber;
    }

    public List<GeoPoint> getPoints() {
        return this.mPoints;
    }

    public boolean isClosedPolygon() {
        return this.mClosedPolygon.equals("1");
    }

    public void setAttributes(LinkedHashMap<String, String> attributes) {
        this.mAttributes = attributes;
    }

    public void setClosedPolygon(boolean closedPolygon) {
        this.mClosedPolygon = closedPolygon ? "1" : "";
    }

    public void setCode(String code) {
        this.mCode = code;
    }

    public void setGeo(Geo geo) {
        this.mGeo = geo;
    }

    public void setLineNumber(String lineNumber) {
        this.mLineNumber = lineNumber;
    }

    public void setPoints(LinkedList<GeoPoint> points) {
        this.mPoints = points;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Line %s,%s,%s".formatted(GeoHelper.toQuotedString(this.mLineNumber), this.mClosedPolygon, GeoHelper.toQuotedString(this.mCode))).append("\r\n");
        sb.append("\tbegin").append("\r\n");
        int indentLevel = 2;
        sb.append((CharSequence)GeoHelper.pointListToStringBuilder(this.mGeo, this.mPoints, 2));
        if (!this.mAttributes.isEmpty()) {
            sb.append((CharSequence)GeoHelper.attributeListToStringBuilder(this.mAttributes, 2));
        }
        sb.append("\tend").append("\r\n");
        return sb.toString();
    }
}

