/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing;

import java.awt.event.ActionListener;
import javax.swing.Timer;

public class DelayedResetRunner {
    private Timer mTimer;
    private long mStart = System.currentTimeMillis();

    public DelayedResetRunner(int delay, Runnable r) {
        ActionListener actionListener = e -> {
            if (System.currentTimeMillis() - this.mStart >= (long)delay) {
                r.run();
                this.mTimer.stop();
            }
        };
        this.mTimer = new Timer(delay, actionListener);
        this.mTimer.start();
    }

    public void reset() {
        this.mStart = System.currentTimeMillis();
        this.mTimer.restart();
    }
}

