/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Robot;
import java.awt.Window;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.lang3.ArrayUtils;
import se.trixon.almond.util.PrefsHelper;

public class SwingHelper {
    private static final String FRAME_H = "Frame_Height";
    private static final String FRAME_STATE = "Frame_State";
    private static final String FRAME_W = "Frame_Width";
    private static final String FRAME_X = "Frame_X";
    private static final String FRAME_Y = "Frame_Y";

    public static void borderPainted(Container container, boolean enable) {
        for (Component component : container.getComponents()) {
            if (!(component instanceof AbstractButton)) continue;
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.setBorderPainted(enable);
        }
    }

    public static void clearText(Container container) {
        for (Component component : container.getComponents()) {
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setText(null);
                continue;
            }
            if (!(component instanceof Container)) continue;
            Container container2 = (Container)component;
            SwingHelper.clearText(container2);
        }
    }

    public static void clearTextButtons(AbstractButton ... abstractButtons) {
        for (AbstractButton abstractButton : abstractButtons) {
            abstractButton.setText(null);
        }
    }

    public static void clearToolTipText(Container container) {
        Component[] components;
        if (container instanceof JMenu) {
            JMenu menu = (JMenu)container;
            components = menu.getMenuComponents();
        } else {
            components = container.getComponents();
        }
        for (Component component : components) {
            if (component instanceof JMenu) {
                JMenu menu = (JMenu)component;
                SwingHelper.clearToolTipText(menu);
                continue;
            }
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setToolTipText(null);
                continue;
            }
            if (!(component instanceof Container)) continue;
            Container container2 = (Container)component;
            SwingHelper.clearToolTipText(container2);
        }
    }

    public static String comboBoxModelToString(ComboBoxModel model) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < model.getSize(); ++i) {
            builder.append(model.getElementAt(i));
            if (i >= model.getSize() - 1) continue;
            builder.append(";");
        }
        return builder.toString();
    }

    public static void enableComponents(Container container, boolean enable, Component ... excludedComponents) {
        for (Component component : container.getComponents()) {
            if (ArrayUtils.contains((Object[])excludedComponents, (Object)component)) continue;
            component.setEnabled(enable);
            if (!(component instanceof Container)) continue;
            Container container2 = (Container)component;
            SwingHelper.enableComponents(container2, enable, new Component[0]);
        }
    }

    public static void frameStateRestore(Preferences preferences, JFrame frame, int defaultWidth, int defaultHeight) throws BackingStoreException {
        if (PrefsHelper.keyExists(preferences, FRAME_X) && PrefsHelper.keyExists(preferences, FRAME_Y) && PrefsHelper.keyExists(preferences, FRAME_H) && PrefsHelper.keyExists(preferences, FRAME_W)) {
            int x = preferences.getInt(FRAME_X, -1);
            int y = preferences.getInt(FRAME_Y, -1);
            frame.setLocation(x, y);
            int h = preferences.getInt(FRAME_H, -1);
            int w = preferences.getInt(FRAME_W, -1);
            frame.setSize(w, h);
            if (PrefsHelper.keyExists(preferences, FRAME_STATE)) {
                frame.setExtendedState(preferences.getInt(FRAME_STATE, -1));
            }
        } else {
            frame.setSize(defaultWidth, defaultHeight);
            frame.setLocationRelativeTo(null);
        }
    }

    public static void frameStateSave(Preferences preferences, JFrame frame) {
        preferences.putInt(FRAME_H, frame.getHeight());
        preferences.putInt(FRAME_W, frame.getWidth());
        preferences.putInt(FRAME_X, frame.getX());
        preferences.putInt(FRAME_Y, frame.getY());
        preferences.putInt(FRAME_STATE, frame.getExtendedState());
        try {
            preferences.sync();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(SwingHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static String getLookAndFeelClassName(String name) {
        String lookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            if (!name.equalsIgnoreCase(info.getName())) continue;
            lookAndFeelClassName = info.getClassName();
            break;
        }
        return lookAndFeelClassName;
    }

    public static DefaultComboBoxModel<String> getLookAndFeelComboBoxModel(boolean addSystem) {
        return new DefaultComboBoxModel<String>(SwingHelper.getLookAndFeelNames(addSystem));
    }

    public static String[] getLookAndFeelNames(boolean addSystem) {
        UIManager.LookAndFeelInfo[] lookAndFeelInfos = UIManager.getInstalledLookAndFeels();
        int size = lookAndFeelInfos.length;
        if (addSystem) {
            ++size;
        }
        Object[] names = new String[size];
        for (int i = 0; i < lookAndFeelInfos.length; ++i) {
            names[i] = lookAndFeelInfos[i].getName();
        }
        if (addSystem) {
            names[lookAndFeelInfos.length] = "System";
        }
        Arrays.sort(names);
        return names;
    }

    public static AbstractButton getSelectedButton(ButtonGroup buttonGroup) {
        Enumeration<AbstractButton> buttons = buttonGroup.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (!button.isSelected()) continue;
            return button;
        }
        return null;
    }

    public static double getUIScale() {
        double defaultFontSize = 12.0;
        Integer fontSize = (Integer)UIManager.get("customFontSize");
        return fontSize == null ? 1.0 : (double)fontSize.intValue() / defaultFontSize;
    }

    public static double getUIScaled(double value) {
        return value * SwingHelper.getUIScale();
    }

    public static int getUIScaled(int value) {
        return (int)((double)value * SwingHelper.getUIScale());
    }

    public static Dimension getUIScaledDim(int width, int height) {
        return new Dimension((int)((double)width * SwingHelper.getUIScale()), (int)((double)height * SwingHelper.getUIScale()));
    }

    public static Dimension getUIScaledDim(double width, double height) {
        return new Dimension((int)(width * SwingHelper.getUIScale()), (int)(height * SwingHelper.getUIScale()));
    }

    public static Insets getUIScaledInsets(int value) {
        return SwingHelper.getUIScaledInsets(value, value, value, value);
    }

    public static Insets getUIScaledInsets(int top, int left, int bottom, int right) {
        return new Insets((int)((double)top * SwingHelper.getUIScale()), (int)((double)left * SwingHelper.getUIScale()), (int)((double)bottom * SwingHelper.getUIScale()), (int)((double)right * SwingHelper.getUIScale()));
    }

    public static void makeWindowResizable(Component component) {
        component.addHierarchyListener(hierarchyEvent -> {
            Dialog dialog;
            Window window = SwingUtilities.getWindowAncestor(component);
            if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                dialog.setResizable(true);
            }
        });
    }

    public static void requestWindowFocusAndRun(Component c, Runnable r) {
        try {
            Robot robot = new Robot();
            robot.mousePress(2048);
            robot.mouseRelease(2048);
        }
        catch (AWTException ex) {
            SwingUtilities.invokeLater(() -> SwingUtilities.getWindowAncestor(c).requestFocus());
        }
        finally {
            SwingHelper.runLaterDelayed(20L, r);
        }
    }

    public static void runAndWait(long delay, Runnable r) {
        SwingUtilities.invokeLater(() -> SwingUtilities.invokeLater(r));
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(SwingHelper.class.getName()).log(Level.SEVERE, null, ex);
            Thread.currentThread().interrupt();
        }
    }

    public static void runLater(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static void runLaterDelayed(long delay, Runnable r) {
        new Thread(() -> {
            try {
                Thread.sleep(delay);
                SwingUtilities.invokeLater(r);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SwingHelper.class.getName()).log(Level.SEVERE, null, ex);
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    public static void setComponentsFont(Container container, Font font) {
        container.setFont(font);
        for (Component component : container.getComponents()) {
            component.setFont(font);
            if (!(component instanceof JMenu)) continue;
            JMenu menu = (JMenu)component;
            SwingHelper.setComponentsFont(menu, font);
        }
    }

    public static void setFullScreen(Window window) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        if (graphicsDevice.isFullScreenSupported()) {
            graphicsDevice.setFullScreenWindow(window);
        }
    }
}

