/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing.dialogs;

import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import se.trixon.almond.util.AlmondOptions;

public class MenuModePanel
extends JPanel {
    private final transient AlmondOptions mAlmondOptions = AlmondOptions.getInstance();
    private ButtonGroup buttonGroup;
    private JLabel label;
    private JRadioButton menuBarRadioButton;
    private JRadioButton menuButtonRadioButton;

    public MenuModePanel() {
        this.initComponents();
        this.load();
    }

    public MenuMode getMenuMode() {
        return this.menuBarRadioButton.isSelected() ? MenuMode.BAR : MenuMode.BUTTON;
    }

    public void save() {
        this.mAlmondOptions.setMenuMode(this.getMenuMode());
    }

    public void setMenuMode(MenuMode menuMode) {
        if (menuMode == MenuMode.BAR) {
            this.menuBarRadioButton.setSelected(true);
        } else {
            this.menuButtonRadioButton.setSelected(true);
        }
    }

    private void load() {
        this.setMenuMode(this.mAlmondOptions.getMenuMode());
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.label = new JLabel();
        this.menuBarRadioButton = new JRadioButton();
        this.menuButtonRadioButton = new JRadioButton();
        ResourceBundle bundle = ResourceBundle.getBundle("se/trixon/almond/util/swing/dialogs/Bundle");
        this.label.setText(bundle.getString("MenuModePanel.label.text"));
        this.buttonGroup.add(this.menuBarRadioButton);
        this.menuBarRadioButton.setText(bundle.getString("MenuModePanel.menuBarRadioButton.text"));
        this.buttonGroup.add(this.menuButtonRadioButton);
        this.menuButtonRadioButton.setText(bundle.getString("MenuModePanel.menuButtonRadioButton.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.label).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.menuBarRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.menuButtonRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.menuBarRadioButton).addComponent(this.menuButtonRadioButton)).addGap(0, 0, Short.MAX_VALUE)));
    }

    public static enum MenuMode {
        BAR,
        BUTTON;

    }
}

