/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing.dialogs.about;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.swing.dialogs.about.AboutPanel;

public abstract class BaseListTab
extends JPanel
implements AboutPanel.TabComponentListener {
    public static final String LIST_SIGN = "\u25cf ";
    protected JEditorPane editorPane;
    private JMenuItem menuItem;
    private JPopupMenu popupMenu;
    protected JScrollPane scrollPane;

    public BaseListTab() {
        this.initComponents();
        this.editorPane.addMouseListener(new PopupListener());
    }

    @Override
    public void reset() {
        this.editorPane.setCaretPosition(0);
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.menuItem = new JMenuItem();
        this.scrollPane = new JScrollPane();
        this.editorPane = new JEditorPane();
        this.menuItem.setText(Dict.COPY.toString());
        this.menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BaseListTab.this.menuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItem);
        this.setLayout(new BorderLayout());
        this.editorPane.setEditable(false);
        this.editorPane.setMargin(new Insets(16, 16, 16, 16));
        this.editorPane.setPreferredSize(new Dimension(72, 24));
        this.scrollPane.setViewportView(this.editorPane);
        this.add((Component)this.scrollPane, "Center");
    }

    private void menuItemActionPerformed(ActionEvent evt) {
        SystemHelper.copyToClipboard(this.editorPane.getText());
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                BaseListTab.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

