/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing.dialogs.about;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang3.StringUtils;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.swing.dialogs.about.AboutPanel;

public class PropertiesTab
extends JPanel
implements AboutPanel.TabComponentListener {
    private DefaultTableModel mModel;
    private int mMaxKeyLength = 0;
    private JMenuItem menuItem;
    private JPopupMenu popupMenu;
    private JScrollPane scrollPane;
    private JTable table;

    public PropertiesTab() {
        this.initComponents();
        this.init();
        this.initSystemProperties();
    }

    @Override
    public void reset() {
        SwingUtilities.invokeLater(() -> this.scrollPane.getVerticalScrollBar().setValue(0));
    }

    private void addSystemProperty(String key) {
        if (System.getProperties().keySet().contains(key)) {
            this.mModel.addRow(new Object[]{key, System.getProperty(key)});
            this.mMaxKeyLength = Math.max(this.mMaxKeyLength, key.length());
        }
    }

    private void init() {
        this.mModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.setModel(this.mModel);
        this.mModel.addColumn(Dict.KEY.toString());
        this.mModel.addColumn(Dict.VALUE.toString());
        this.table.getColumnModel().getColumn(1).setPreferredWidth(280);
        this.table.setAutoResizeMode(4);
        this.table.addMouseListener(new PopupListener());
    }

    private void initSystemProperties() {
        String[] keys;
        for (String key : keys = new String[]{"user.country", "user.home", "user.language", "user.name", "user.timezone", "", "os.arch", "os.name", "os.version", "", "file.encoding.pkg", "file.encoding", "file.separator", "path.separator", "", "netbeans.home", "netbeans.user", "netbeans.dirs", "netbeans.running.environment", "netbeans.productversion", "netbeans.buildnumber", "netbeans.dynamic.classpath", "netbeans.logger.console", "", "java.awt.graphicsenv", "java.awt.printerjob", "java.class.path", "java.class.version", "java.endorsed.dirs", "java.ext.dirs", "java.home", "java.io.tmpdir", "java.library.path", "java.runtime.name", "java.runtime.version", "java.specification.name", "java.specification.vendor", "java.specification.version", "java.vendor", "java.vendor.url.bug", "java.vendor.url", "java.version", "java.vm.info", "java.vm.name", "java.vm.specification.name", "java.vm.specification.vendor", "java.vm.specification.version", "java.vm.vendor", "java.vm.version", "", "sun.arch.data.model", "sun.boot.class.path", "sun.boot.library.path", "sun.cpu.endian", "sun.cpu.isalist", "sun.io.unicode.encoding", "sun.java.launcher", "sun.jnu.encoding", "sun.management.compiler", "sun.os.patch.level"}) {
            if (key.isEmpty()) {
                this.mModel.addRow(new Object[]{"", ""});
                continue;
            }
            this.addSystemProperty(key);
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.menuItem = new JMenuItem();
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.menuItem.setText(Dict.COPY.toString());
        this.menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertiesTab.this.menuItemActionPerformed(evt);
            }
        });
        this.popupMenu.add(this.menuItem);
        this.scrollPane.setPreferredSize(new Dimension(450, 200));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.scrollPane.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE));
    }

    private void menuItemActionPerformed(ActionEvent evt) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.mModel.getRowCount(); ++i) {
            String key = (String)this.mModel.getValueAt(i, 0);
            String val = (String)this.mModel.getValueAt(i, 1);
            builder.append(StringUtils.rightPad((String)key, (int)(this.mMaxKeyLength + 2))).append(val).append("\n");
        }
        SystemHelper.copyToClipboard(builder.toString());
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                PropertiesTab.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

