/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.util.swing.dialogs.cron;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.swing.dialogs.NotificationLine;
import se.trixon.almond.util.swing.dialogs.cron.CronExprChangeListener;
import se.trixon.almond.util.swing.dialogs.cron.ElementDomPanel;
import se.trixon.almond.util.swing.dialogs.cron.ElementDowPanel;
import se.trixon.almond.util.swing.dialogs.cron.ElementHourPanel;
import se.trixon.almond.util.swing.dialogs.cron.ElementMinutePanel;
import se.trixon.almond.util.swing.dialogs.cron.ElementMonthPanel;
import se.trixon.almond.util.swing.dialogs.cron.ElementPanel;
import se.trixon.almond.util.swing.dialogs.cron.Preset;

public class CronPanel
extends JPanel
implements CronExprChangeListener {
    ElementPanel[] mElementPanels = new ElementPanel[5];
    private final transient ResourceBundle mBundle = SystemHelper.getBundle(CronPanel.class, "Bundle");
    protected CronExprChangeListener mCronExprChangeListener;
    private ElementDomPanel elementDomPanel;
    private ElementDowPanel elementDowPanel;
    private ElementHourPanel elementHourPanel;
    private ElementMinutePanel elementMinutePanel;
    private ElementMonthPanel elementMonthPanel;
    private JPanel elementsPanel;
    private JPanel jPanel1;
    private NotificationLine notificationLine;
    private JComboBox<Preset> presetComboBox;
    private JLabel presetLabel;

    public CronPanel() {
        this.initComponents();
        this.initPresets();
        this.mElementPanels[0] = this.elementMinutePanel;
        this.mElementPanels[1] = this.elementHourPanel;
        this.mElementPanels[2] = this.elementDomPanel;
        this.mElementPanels[3] = this.elementMonthPanel;
        this.mElementPanels[4] = this.elementDowPanel;
        for (ElementPanel elementPanel : this.mElementPanels) {
            elementPanel.setCronExprChangeListener(this);
        }
    }

    public String getCronString() {
        String cron = "%s %s %s %s %s".formatted(this.mElementPanels[0].getCronString(), this.mElementPanels[1].getCronString(), this.mElementPanels[2].getCronString(), this.mElementPanels[3].getCronString(), this.mElementPanels[4].getCronString());
        return cron;
    }

    public NotificationLine getNotificationLine() {
        return this.notificationLine;
    }

    public boolean isCronValid() {
        boolean valid = true;
        for (ElementPanel elementPanel : this.mElementPanels) {
            String cron = elementPanel.getCronString();
            if (!cron.isEmpty() && !cron.startsWith("/")) continue;
            valid = false;
        }
        return valid;
    }

    @Override
    public void onCronExprChanged() {
        try {
            if (this.isCronValid()) {
                if (this.mCronExprChangeListener != null) {
                    this.mCronExprChangeListener.onCronExprChanged(this.getCronString());
                }
                this.notificationLine.displayInformationMessage(this.getCronString());
            } else {
                if (this.mCronExprChangeListener != null) {
                    this.mCronExprChangeListener.onCronExprInvalid();
                }
                this.notificationLine.displayErrorMessage(this.getCronString());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void onCronExprChanged(String cronString) {
    }

    @Override
    public void onCronExprInvalid() {
    }

    public void setCronString(String cronString) {
        if (cronString == null) {
            cronString = "0 * * * *";
        }
        String[] cronItems = cronString.split(" ");
        for (int i = 0; i < 5; ++i) {
            try {
                this.mElementPanels[i].setCronString(cronItems[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.mElementPanels[i].setCronString("*");
            }
        }
        this.onCronExprChanged();
    }

    public void setCronExprChangeListener(CronExprChangeListener cronExprChangeListener) {
        this.mCronExprChangeListener = cronExprChangeListener;
    }

    private void initPresets() {
        ArrayList<Preset> presets = new ArrayList<Preset>();
        presets.add(new Preset());
        presets.add(new Preset(this.mBundle.getString("preset1"), "*/10 * * * * *"));
        presets.add(new Preset(this.mBundle.getString("preset2"), "0 * * * * *"));
        presets.add(new Preset(this.mBundle.getString("preset3"), "*/15 8-17 * * 1-5"));
        presets.add(new Preset(this.mBundle.getString("preset4"), "0 12 */2 * *"));
        presets.add(new Preset(this.mBundle.getString("preset5"), "* 6-8,18-20 * 5 *"));
        DefaultComboBoxModel<Preset> comboBoxModel = new DefaultComboBoxModel<Preset>();
        for (Preset preset : presets) {
            comboBoxModel.addElement(preset);
        }
        this.presetComboBox.setModel(comboBoxModel);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.presetLabel = new JLabel();
        this.presetComboBox = new JComboBox();
        this.elementsPanel = new JPanel();
        this.elementMinutePanel = new ElementMinutePanel();
        this.elementHourPanel = new ElementHourPanel();
        this.elementDomPanel = new ElementDomPanel();
        this.elementMonthPanel = new ElementMonthPanel();
        this.elementDowPanel = new ElementDowPanel();
        this.notificationLine = new NotificationLine();
        this.setLayout(new BorderLayout());
        this.presetLabel.setText(Dict.PRESETS.toString());
        this.presetComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CronPanel.this.presetComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.presetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.presetComboBox, -2, -1, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.presetLabel).addComponent(this.presetComboBox, -2, -1, -2)).addContainerGap()));
        this.add((Component)this.jPanel1, "First");
        this.elementsPanel.setLayout(new GridLayout(1, 0));
        ResourceBundle bundle = ResourceBundle.getBundle("se/trixon/almond/util/swing/dialogs/cron/Bundle");
        this.elementMinutePanel.setText(bundle.getString("CronPanel.elementMinutePanel.text"));
        this.elementsPanel.add(this.elementMinutePanel);
        this.elementHourPanel.setText(bundle.getString("CronPanel.elementHourPanel.text"));
        this.elementsPanel.add(this.elementHourPanel);
        this.elementDomPanel.setText(bundle.getString("CronPanel.elementDomPanel.text"));
        this.elementsPanel.add(this.elementDomPanel);
        this.elementMonthPanel.setText(bundle.getString("CronPanel.elementMonthPanel.text"));
        this.elementsPanel.add(this.elementMonthPanel);
        this.elementDowPanel.setText(bundle.getString("CronPanel.elementDowPanel.text"));
        this.elementsPanel.add(this.elementDowPanel);
        this.add((Component)this.elementsPanel, "Center");
        this.add((Component)this.notificationLine, "Last");
    }

    private void presetComboBoxActionPerformed(ActionEvent evt) {
        if (this.presetComboBox.getSelectedIndex() > 0) {
            Preset preset = (Preset)this.presetComboBox.getSelectedItem();
            this.setCronString(preset.getPattern());
        }
    }
}

