/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox.time;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public enum Dates {
    yyyy_MM_dd("yyyy-MM-dd"),
    yyyy_MM("yyyy-MM"),
    yyyyMMdd("yyyyMMdd"),
    yyyyMM("yyyyMM"),
    yyyy("yyyy"),
    yyyy_w("yyyy-'W'w"),
    yyyyw("yyyy'W'w"),
    yyyy_w_e("yyyy-'W'w-e"),
    yyyywe("yyyy'W'we"),
    dd_MM_yyyy("dd-MM-yyyy"),
    MM_dd_yyyy("MM-dd-yyyy"),
    MMMM_dd_yyyy("MMMM dd, yyyy"),
    MMMM_dd("MMMM dd"),
    MMM_dd_yyyy("MMM dd, yyyy"),
    MMM_dd("MMM dd"),
    dd_MMM_yyyy("dd MMM yyyy"),
    dd_MMM("dd MMM"),
    dd_MMMM_yyyy("dd MMMM yyyy"),
    dd_MMMM("dd MMMM");

    private final DateTimeFormatter formatter;

    private Dates(String formatString) {
        this.formatter = DateTimeFormatter.ofPattern(formatString);
    }

    public LocalDate parse(String text) {
        return LocalDate.parse(text, this.formatter);
    }

    public Date parseDate(String text) {
        return this.parseDate(text, ZoneId.systemDefault());
    }

    public Date parseDate(String text, ZoneId zoneId) {
        return Date.from(this.parse(text).atStartOfDay().atZone(zoneId).toInstant());
    }

    public String format(LocalDate date) {
        return this.formatter.format(date);
    }

    public String format(Date date) {
        return this.format(date, ZoneId.systemDefault());
    }

    public String format(Date date, ZoneId zoneId) {
        return this.format(date.toInstant().atZone(zoneId).toLocalDate());
    }
}

