/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra;

import de.gsi.dataset.utils.AssertUtils;
import de.gsi.math.MathBase;
import java.util.Map;
import java.util.WeakHashMap;

public enum Apodization {
    Rectangular("rectangular"),
    Hamming("Hamming"),
    Hann("von Hann"),
    HannExp("exp. von Hann"),
    Blackman("Blackman"),
    Nuttall("Nuttall"),
    BlackmanHarris("Blackman-Harris"),
    BlackmanNuttall("Blackman-Nuttall"),
    FlatTop("Flat-Top"),
    Exponential("exponential");

    private static Map<ApodizationArrayDescription, double[]> windowCache;
    private final String fname;

    private Apodization(String name) {
        this.fname = name;
    }

    public void apodize(double[] data) {
        double[] window = this.getWindow(data.length);
        for (int i = 0; i < data.length; ++i) {
            data[i] = data[i] * window[i];
        }
    }

    public double getIndex(int i, int n) {
        return this.getWindow(n)[i];
    }

    public double getIndex(int i, int n, double m) {
        switch (this) {
            case Hamming: {
                return this.getIndex(i, n);
            }
            case HannExp: {
                double a = Math.PI * 2 / (double)(n - 1);
                return Math.pow(Math.sin(a * (double)i), m);
            }
        }
        return this.getIndex(i, n);
    }

    public double getIndexUncached(int i, int n) {
        switch (this) {
            case Hamming: {
                double a = Math.PI * 2 / (double)n;
                return 0.53836 - 0.46164 * MathBase.cos(a * (double)i);
            }
            case Hann: {
                double a = Math.PI * 2 / (double)(n - 1);
                return 0.5 - 0.5 * MathBase.cos(a * (double)i);
            }
            case HannExp: {
                double a = Math.PI * 2 / (double)(n - 1);
                return Math.pow(MathBase.sin(a * (double)i), 2.0);
            }
            case Blackman: {
                double a = Math.PI * 2 / (double)(n - 1);
                return 0.42 - 0.5 * MathBase.cos(a * (double)i) + 0.08 * MathBase.cos(2.0 * a * (double)i);
            }
            case Nuttall: {
                double a = Math.PI * 2 / (double)(n - 1);
                return 0.355768 - 0.487396 * MathBase.cos(a * (double)i) + 0.144232 * MathBase.cos(2.0 * a * (double)i) - 0.012604 * MathBase.cos(3.0 * a * (double)i);
            }
            case BlackmanHarris: {
                double a = Math.PI * 2 / (double)(n - 1);
                return 0.35875 - 0.48829 * MathBase.cos(a * (double)i) + 0.14128 * MathBase.cos(2.0 * a * (double)i) - 0.01168 * MathBase.cos(3.0 * a * (double)i);
            }
            case BlackmanNuttall: {
                double a = Math.PI * 2 / (double)(n - 1);
                return 0.3635819 - 0.4891775 * MathBase.cos(a * (double)i) + 0.1365995 * MathBase.cos(2.0 * a * (double)i) - 0.0106411 * MathBase.cos(3.0 * a * (double)i);
            }
            case FlatTop: {
                double a = Math.PI * 2 / (double)(n - 1);
                return 1.0 - 1.93 * MathBase.cos(a * (double)i) + 1.29 * MathBase.cos(2.0 * a * (double)i) - 0.388 * MathBase.cos(3.0 * a * (double)i) + 0.032 * MathBase.cos(4.0 * a * (double)i);
            }
            case Exponential: {
                double a = 3 * n;
                double exp0 = MathBase.exp(0.0);
                return MathBase.exp((double)i / a) / exp0;
            }
        }
        return 1.0;
    }

    public String getName() {
        return this.fname;
    }

    public double[] getWindow(int n) {
        return windowCache.computeIfAbsent(new ApodizationArrayDescription(this, n), desc -> {
            double[] window = new double[desc.length];
            for (int i = 0; i < desc.length; ++i) {
                window[i] = this.getIndexUncached(i, desc.length);
            }
            return window;
        });
    }

    public static void apodize(double[] data, Apodization function) {
        function.apodize(data);
    }

    public static Map<ApodizationArrayDescription, double[]> getWindowCache() {
        return windowCache;
    }

    public static void setWindowCache(Map<ApodizationArrayDescription, double[]> windowCache) {
        Apodization.windowCache = windowCache;
    }

    static {
        windowCache = new WeakHashMap<ApodizationArrayDescription, double[]>();
    }

    protected static class ApodizationArrayDescription {
        protected final Apodization apodization;
        protected final int length;

        public ApodizationArrayDescription(Apodization apodization, int length) {
            AssertUtils.notNull((String)"apodization", (Object)((Object)apodization));
            this.apodization = apodization;
            this.length = length;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ApodizationArrayDescription)) {
                return false;
            }
            ApodizationArrayDescription other = (ApodizationArrayDescription)obj;
            return this.apodization == other.apodization && this.length == other.length;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.apodization.hashCode();
            result = 31 * result + this.length;
            return result;
        }
    }
}

