/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.dtft;

import de.gsi.math.Math;
import de.gsi.math.MathBase;
import de.gsi.math.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DiscreteTimeFourierTransform {
    protected int START_THREADS = 128;
    protected boolean DEBUG = false;

    public double[] computeFrequencyRange(double[] time) {
        double t_range = Math.maximum(time) - Math.minimum(time);
        double t_min = Double.MAX_VALUE;
        for (int i = 1; i < time.length; ++i) {
            double diff = MathBase.abs(time[i] - time[i - 1]);
            if (!(t_min > diff) || !(t_min > 0.0)) continue;
            t_min = diff;
        }
        double f_s = 1.0 / t_min;
        int nTestFrequencies = (int)(t_range / t_min);
        double[] testFrequencies = new double[nTestFrequencies];
        double scale = 0.5 / (double)nTestFrequencies * f_s;
        for (int i = 0; i < nTestFrequencies; ++i) {
            testFrequencies[i] = (double)i * scale;
        }
        return testFrequencies;
    }

    public double[] computeMagnitudeSpectrum(double[] t, double[] val) {
        return this.computeMagnitudeSpectrum(t, val, this.computeFrequencyRange(t));
    }

    public double[] computeMagnitudeSpectrum(double[] t, double[] val, double[] testFrequencies) {
        int n = testFrequencies.length;
        int tn = t.length;
        double[] ret = new double[n];
        long start = System.nanoTime();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && n > this.START_THREADS) {
            Future[] futures = new Future[nthreads];
            int k = n / nthreads;
            for (int thread = 0; thread < nthreads; ++thread) {
                int firstIdx = thread * k;
                int lastIdx = thread == nthreads - 1 ? n : firstIdx + k;
                futures[thread] = ConcurrencyUtils.submit(() -> {
                    for (int i = firstIdx; i < lastIdx; ++i) {
                        double omega = java.lang.Math.PI * 2 * testFrequencies[i];
                        double sum1 = 0.0;
                        double sum2 = 0.0;
                        for (int j = 0; j < tn; ++j) {
                            sum1 += val[j] * MathBase.cos(omega * t[j]);
                            sum2 += val[j] * MathBase.sin(omega * t[j]);
                        }
                        ret[i] = 2.0 * MathBase.sqrt(MathBase.sqr(sum1 /= (double)tn) + MathBase.sqr(sum2 /= (double)tn));
                    }
                });
            }
        } else {
            double sum1 = 0.0;
            double sum2 = 0.0;
            for (int i = 0; i < n; ++i) {
                double omega = java.lang.Math.PI * 2 * testFrequencies[i];
                for (int j = 0; j < t.length; ++j) {
                    sum1 += val[j] * MathBase.cos(omega * t[j]);
                    sum2 += val[j] * MathBase.sin(omega * t[j]);
                }
                ret[i] = 2.0 * MathBase.sqrt(MathBase.sqr(sum1 /= (double)t.length) + MathBase.sqr(sum2 /= (double)t.length));
            }
        }
        long stop = System.nanoTime();
        if (this.DEBUG) {
            System.err.printf("computeMagnitudeSpectrum(double[], double[], double[]) - took %f ms\n", (double)(stop - start) * 1.0E-6);
        }
        return ret;
    }
}

