/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.wavelet;

public abstract class Lift {
    public void forwardTrans(double[] vec) {
        int N;
        for (int n = N = vec.length; n > 1; n >>= 1) {
            this.split(vec, n);
            this.predict(vec, n, Direction.forward);
            this.update(vec, n, Direction.forward);
        }
    }

    public void inverseTrans(double[] vec) {
        int N = vec.length;
        for (int n = 2; n <= N; n <<= 1) {
            this.update(vec, n, Direction.inverse);
            this.predict(vec, n, Direction.inverse);
            this.merge(vec, n);
        }
    }

    protected void merge(double[] vec, int N) {
        int half = N >> 1;
        int start = half - 1;
        int end = half;
        while (start > 0) {
            for (int i = start; i < end; i += 2) {
                double tmp = vec[i];
                vec[i] = vec[i + 1];
                vec[i + 1] = tmp;
            }
            --start;
            ++end;
        }
    }

    protected abstract void predict(double[] var1, int var2, Direction var3);

    protected void split(double[] vec, int N) {
        int start = 1;
        for (int end = N - 1; start < end; ++start, --end) {
            for (int i = start; i < end; i += 2) {
                double tmp = vec[i];
                vec[i] = vec[i + 1];
                vec[i + 1] = tmp;
            }
        }
    }

    protected abstract void update(double[] var1, int var2, Direction var3);

    protected static enum Direction {
        forward,
        inverse;

    }
}

