/*
 * Decompiled with CFR 0.152.
 */
package com.helger.font.api;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.string.StringHelper;
import com.helger.font.api.EFontType;
import com.helger.font.api.IFontResource;
import com.helger.font.api.IFontResourceProviderSPI;
import com.helger.font.api.IFontWeight;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class FontResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FontResourceManager.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsOrderedSet<IFontResource> s_aItems = new CommonsLinkedHashSet();

    private FontResourceManager() {
    }

    public static void reInit(@Nullable ClassLoader classLoader) {
        s_aRWLock.writeLocked(() -> {
            s_aItems.clear();
            ClassLoader classLoader2 = classLoader != null ? classLoader : ClassLoaderHelper.getDefaultClassLoader();
            for (IFontResourceProviderSPI iFontResourceProviderSPI : ServiceLoaderHelper.getAllSPIImplementations(IFontResourceProviderSPI.class, (ClassLoader)classLoader2)) {
                for (IFontResource iFontResource : iFontResourceProviderSPI.getAllFontResources()) {
                    if (s_aItems.add((Object)iFontResource)) continue;
                    LOGGER.warn("Failed to register font resource " + iFontResource + " because this resource is already contained!");
                }
            }
            if (s_aItems.isEmpty()) {
                LOGGER.info("No font resources available for registration!");
            } else {
                LOGGER.info("Successfully registered " + s_aItems.size() + " font resources!");
            }
        });
    }

    @Nonnegative
    public static int getRegisteredResourceCount() {
        return s_aRWLock.readLockedInt(() -> s_aItems.size());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<IFontResource> getAllResources() {
        return (ICommonsOrderedSet)s_aRWLock.readLockedGet(() -> s_aItems.getClone());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<IFontResource> getAllResources(@Nullable Predicate<? super IFontResource> predicate) {
        if (predicate == null) {
            return FontResourceManager.getAllResources();
        }
        return (ICommonsOrderedSet)s_aRWLock.readLockedGet(() -> CollectionHelper.newOrderedSet(s_aItems, (Predicate)predicate));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<IFontResource> getAllResourcesOfFontType(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return new CommonsLinkedHashSet();
        }
        return FontResourceManager.getAllResources(iFontResource -> iFontResource.getFontName().equals(string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<IFontResource> getAllResourcesOfFontType(@Nullable EFontType eFontType) {
        if (eFontType == null) {
            return new CommonsLinkedHashSet();
        }
        return FontResourceManager.getAllResources(iFontResource -> iFontResource.getFontType().equals((Object)eFontType));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<IFontResource> getAllResourcesOfFontWeight(@Nullable IFontWeight iFontWeight) {
        if (iFontWeight == null) {
            return new CommonsLinkedHashSet();
        }
        return FontResourceManager.getAllResources(iFontResource -> iFontResource.getFontWeight().equals(iFontWeight));
    }

    static {
        FontResourceManager.reInit(null);
    }
}

