/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.base;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EPLPlaceholder {
    PAGESET_INDEX("${pageset-index}", 1),
    PAGESET_NUMBER("${pageset-number}", 1),
    PAGESET_COUNT("${pageset-count}", 1),
    PAGESET_PAGE_INDEX("${pageset-page-index}", 2),
    PAGESET_PAGE_NUMBER("${pageset-page-number}", 2),
    PAGESET_PAGE_COUNT("${pageset-page-count}", 2),
    TOTAL_PAGE_INDEX("${total-page-index}", 2),
    TOTAL_PAGE_NUMBER("${total-page-number}", 2),
    TOTAL_PAGE_COUNT("${total-page-count}", 2);

    private final String m_sVariable;
    private final int m_nEstimatedCharCount;
    private final String m_sEstimatedPrepareText;

    private EPLPlaceholder(String string2, int n2) {
        this.m_sVariable = string2;
        this.m_nEstimatedCharCount = n2;
        this.m_sEstimatedPrepareText = StringHelper.getRepeated((char)'X', (int)n2);
    }

    @Nonnull
    @Nonempty
    public String getVariable() {
        return this.m_sVariable;
    }

    @Nonnegative
    public int getEstimatedCharCount() {
        return this.m_nEstimatedCharCount;
    }

    @Nonnull
    @Nonempty
    public String getEstimatedPrepareText() {
        return this.m_sEstimatedPrepareText;
    }

    @Nullable
    public static EPLPlaceholder getFromVariableOrNull(@Nullable String string) {
        return (EPLPlaceholder)((Object)ArrayHelper.findFirst((Object[])EPLPlaceholder.values(), ePLPlaceholder -> ePLPlaceholder.getVariable().equals(string)));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, String> getEstimationReplacements() {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        for (EPLPlaceholder ePLPlaceholder : EPLPlaceholder.values()) {
            commonsHashMap.put((Object)ePLPlaceholder.m_sVariable, (Object)ePLPlaceholder.m_sEstimatedPrepareText);
        }
        return commonsHashMap;
    }
}

