/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.base;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.base.IPLRenderableObject;
import com.helger.pdflayout.spec.SizeSpec;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PLElementWithSize {
    private final IPLRenderableObject<?> m_aElement;
    private final SizeSpec m_aSize;
    private final SizeSpec m_aSizeFull;

    public PLElementWithSize(@Nonnull IPLRenderableObject<?> iPLRenderableObject, @Nonnull SizeSpec sizeSpec) {
        this(iPLRenderableObject, sizeSpec, sizeSpec.plus(iPLRenderableObject.getOutlineXSum(), iPLRenderableObject.getOutlineYSum()));
    }

    public PLElementWithSize(@Nonnull IPLRenderableObject<?> iPLRenderableObject, @Nonnull SizeSpec sizeSpec, @Nonnull SizeSpec sizeSpec2) {
        ValueEnforcer.notNull(iPLRenderableObject, (String)"Element");
        ValueEnforcer.notNull((Object)sizeSpec, (String)"Size");
        ValueEnforcer.notNull((Object)sizeSpec2, (String)"SizeFull");
        this.m_aElement = iPLRenderableObject;
        this.m_aSize = sizeSpec;
        this.m_aSizeFull = sizeSpec2;
    }

    @Nonnull
    public IPLRenderableObject<?> getElement() {
        return this.m_aElement;
    }

    @Nonnull
    public SizeSpec getSize() {
        return this.m_aSize;
    }

    @Nonnull
    public SizeSpec getSizeFull() {
        return this.m_aSizeFull;
    }

    public float getWidth() {
        return this.m_aSize.getWidth();
    }

    public float getWidthFull() {
        return this.m_aSizeFull.getWidth();
    }

    public float getHeight() {
        return this.m_aSize.getHeight();
    }

    public float getHeightFull() {
        return this.m_aSizeFull.getHeight();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("element", this.m_aElement).append("size", (Object)this.m_aSize).append("sizeFull", (Object)this.m_aSizeFull).getToString();
    }
}

