/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.base;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.pdflayout.base.PLElementWithSize;
import com.helger.pdflayout.base.PLMarginBorderPadding;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class PLPageSetPrepareResult {
    private PLMarginBorderPadding m_aFirstPageMBP;
    private float m_fFirstHeaderHeight = Float.NaN;
    private float m_fHeaderHeight = Float.NaN;
    private final ICommonsList<PLElementWithSize> m_aContentHeight = new CommonsArrayList();
    private float m_fFirstFooterHeight = Float.NaN;
    private float m_fFooterHeight = Float.NaN;
    private final ICommonsList<ICommonsList<PLElementWithSize>> m_aPerPageElements = new CommonsArrayList();

    PLPageSetPrepareResult() {
    }

    @Nonnull
    PLMarginBorderPadding getFirstPageMBP() {
        PLMarginBorderPadding pLMarginBorderPadding = this.m_aFirstPageMBP;
        if (pLMarginBorderPadding == null) {
            throw new IllegalStateException("No first page margin border padding present");
        }
        return pLMarginBorderPadding;
    }

    void setFirstPageMBP(@Nonnull PLMarginBorderPadding pLMarginBorderPadding) {
        ValueEnforcer.notNull((Object)pLMarginBorderPadding, (String)"FirstPageMBP");
        this.m_aFirstPageMBP = pLMarginBorderPadding;
    }

    float getHeaderHeight(@Nonnegative int n) {
        if (n == 0 && !Float.isNaN(this.m_fFirstHeaderHeight)) {
            return this.m_fFirstHeaderHeight;
        }
        return this.m_fHeaderHeight;
    }

    void setHeaderHeight(float f) {
        this.m_fHeaderHeight = Float.isNaN(this.m_fHeaderHeight) ? f : Math.max(this.m_fHeaderHeight, f);
    }

    void setFirstHeaderHeight(float f) {
        ValueEnforcer.isTrue((boolean)Float.isNaN(this.m_fFirstHeaderHeight), (String)"First header height was already set");
        this.m_fFirstHeaderHeight = f;
    }

    void addElement(@Nonnull PLElementWithSize pLElementWithSize) {
        ValueEnforcer.notNull((Object)pLElementWithSize, (String)"Element");
        this.m_aContentHeight.add((Object)pLElementWithSize);
    }

    @Nonnull
    @ReturnsMutableCopy
    ICommonsList<PLElementWithSize> getAllElements() {
        return (ICommonsList)this.m_aContentHeight.getClone();
    }

    @Nonnull
    @ReturnsMutableObject(value="speed")
    ICommonsList<ICommonsList<PLElementWithSize>> directGetPerPageElements() {
        return this.m_aPerPageElements;
    }

    void addPerPageElements(@Nonnull @Nonempty ICommonsList<PLElementWithSize> iCommonsList) {
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, (String)"CurPageElements");
        this.m_aPerPageElements.add(iCommonsList);
    }

    @Nonnegative
    public int getPageCount() {
        return this.m_aPerPageElements.size();
    }

    @Nonnegative
    public int getPageNumber() {
        return this.getPageCount() + 1;
    }

    float getFooterHeight(@Nonnegative int n) {
        if (n == 0 && !Float.isNaN(this.m_fFirstFooterHeight)) {
            return this.m_fFirstFooterHeight;
        }
        return this.m_fFooterHeight;
    }

    void setFirstFooterHeight(float f) {
        ValueEnforcer.isTrue((boolean)Float.isNaN(this.m_fFirstFooterHeight), (String)"First footer height was already set");
        this.m_fFirstFooterHeight = f;
    }

    void setFooterHeight(float f) {
        this.m_fFooterHeight = Float.isNaN(this.m_fFooterHeight) ? f : Math.max(this.m_fFooterHeight, f);
    }
}

