/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.config.xml;

import com.helger.pdflayout.element.table.PLCellRange;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PLCellRangeMicroTypeConverter
implements IMicroTypeConverter<PLCellRange> {
    private static final String ATTR_FIRST_ROW = "firstrow";
    private static final String ATTR_LAST_ROW = "lastrow";
    private static final String ATTR_FIRST_COLUMN = "firstcol";
    private static final String ATTR_LAST_COLUMN = "lastcol";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull PLCellRange pLCellRange, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_FIRST_ROW, pLCellRange.getFirstRow());
        microElement.setAttribute(ATTR_LAST_ROW, pLCellRange.getLastRow());
        microElement.setAttribute(ATTR_FIRST_COLUMN, pLCellRange.getFirstColumn());
        microElement.setAttribute(ATTR_LAST_COLUMN, pLCellRange.getLastColumn());
        return microElement;
    }

    @Nonnull
    public PLCellRange convertToNative(@Nonnull IMicroElement iMicroElement) {
        int n = iMicroElement.getAttributeValueAsInt(ATTR_FIRST_ROW, 0);
        int n2 = iMicroElement.getAttributeValueAsInt(ATTR_LAST_ROW, 0);
        int n3 = iMicroElement.getAttributeValueAsInt(ATTR_FIRST_COLUMN, 0);
        int n4 = iMicroElement.getAttributeValueAsInt(ATTR_LAST_COLUMN, 0);
        return new PLCellRange(n, n2, n3, n4);
    }
}

