/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.hbox;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.base.AbstractPLElement;
import com.helger.pdflayout.base.AbstractPLRenderableObject;
import com.helger.pdflayout.base.IPLRenderableObject;
import com.helger.pdflayout.base.IPLSplittableObject;
import com.helger.pdflayout.base.IPLVisitor;
import com.helger.pdflayout.base.PLElementWithSize;
import com.helger.pdflayout.base.PLSplitResult;
import com.helger.pdflayout.debug.PLDebugLog;
import com.helger.pdflayout.element.hbox.PLHBoxColumn;
import com.helger.pdflayout.element.special.PLSpacerX;
import com.helger.pdflayout.render.PageRenderContext;
import com.helger.pdflayout.render.PreparationContext;
import com.helger.pdflayout.spec.SizeSpec;
import com.helger.pdflayout.spec.WidthSpec;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractPLHBox<IMPLTYPE extends AbstractPLHBox<IMPLTYPE>>
extends AbstractPLRenderableObject<IMPLTYPE>
implements IPLSplittableObject<IMPLTYPE, IMPLTYPE> {
    private final ICommonsList<PLHBoxColumn> m_aColumns = new CommonsArrayList();
    private boolean m_bVertSplittable = true;
    private SizeSpec[] m_aPreparedColumnSizes;
    private SizeSpec[] m_aPreparedElementSizes;

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public IMPLTYPE setBasicDataFrom(@Nonnull IMPLTYPE IMPLTYPE) {
        super.setBasicDataFrom(IMPLTYPE);
        this.setVertSplittable(((AbstractPLHBox)IMPLTYPE).isVertSplittable());
        return (IMPLTYPE)((AbstractPLHBox)this.thisAsT());
    }

    @Nonnegative
    public int getColumnCount() {
        return this.m_aColumns.size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PLHBoxColumn> getAllColumns() {
        return (ICommonsList)this.m_aColumns.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public Iterable<PLHBoxColumn> getColumns() {
        return this.m_aColumns;
    }

    public void forEachColumn(@Nonnull Consumer<? super PLHBoxColumn> consumer) {
        this.m_aColumns.forEach(consumer);
    }

    public void forEachColumnByIndex(@Nonnull ObjIntConsumer<? super PLHBoxColumn> objIntConsumer) {
        this.m_aColumns.forEachByIndex(objIntConsumer);
    }

    @Nullable
    public PLHBoxColumn getColumnAtIndex(@Nonnegative int n) {
        return (PLHBoxColumn)this.m_aColumns.getAtIndex(n);
    }

    @Nullable
    public PLHBoxColumn getFirstColumn() {
        return (PLHBoxColumn)this.m_aColumns.getFirst();
    }

    @Nullable
    public PLHBoxColumn getLastColumn() {
        return (PLHBoxColumn)this.m_aColumns.getLast();
    }

    @Nullable
    public IPLRenderableObject<?> getColumnElementAtIndex(@Nonnegative int n) {
        PLHBoxColumn pLHBoxColumn = this.getColumnAtIndex(n);
        return pLHBoxColumn == null ? null : pLHBoxColumn.getElement();
    }

    @Nullable
    public IPLRenderableObject<?> getFirstColumnElement() {
        PLHBoxColumn pLHBoxColumn = this.getFirstColumn();
        return pLHBoxColumn == null ? null : pLHBoxColumn.getElement();
    }

    @Nullable
    public IPLRenderableObject<?> getLastColumnElement() {
        PLHBoxColumn pLHBoxColumn = this.getLastColumn();
        return pLHBoxColumn == null ? null : pLHBoxColumn.getElement();
    }

    private void _addAndReturnColumn(@CheckForSigned int n, @Nonnull PLHBoxColumn pLHBoxColumn) {
        this.internalCheckNotPrepared();
        if (n < 0 || n >= this.m_aColumns.size()) {
            this.m_aColumns.add((Object)pLHBoxColumn);
        } else {
            this.m_aColumns.add(n, (Object)pLHBoxColumn);
        }
    }

    @Nonnull
    public PLHBoxColumn addAndReturnColumn(@Nonnull IPLRenderableObject<?> iPLRenderableObject, @Nonnull WidthSpec widthSpec) {
        return this.addAndReturnColumn(-1, iPLRenderableObject, widthSpec);
    }

    @Nonnull
    public IMPLTYPE addColumn(@Nonnull IPLRenderableObject<?> iPLRenderableObject, @Nonnull WidthSpec widthSpec) {
        this.addAndReturnColumn(-1, iPLRenderableObject, widthSpec);
        return (IMPLTYPE)((AbstractPLHBox)this.thisAsT());
    }

    @Nonnull
    public PLHBoxColumn addAndReturnColumn(@CheckForSigned int n, @Nonnull IPLRenderableObject<?> iPLRenderableObject, @Nonnull WidthSpec widthSpec) {
        PLHBoxColumn pLHBoxColumn = new PLHBoxColumn(iPLRenderableObject, widthSpec);
        this._addAndReturnColumn(n, pLHBoxColumn);
        return pLHBoxColumn;
    }

    @Nonnull
    public IMPLTYPE addColumn(@CheckForSigned int n, @Nonnull IPLRenderableObject<?> iPLRenderableObject, @Nonnull WidthSpec widthSpec) {
        this.addAndReturnColumn(n, iPLRenderableObject, widthSpec);
        return (IMPLTYPE)((AbstractPLHBox)this.thisAsT());
    }

    @Nonnull
    public IMPLTYPE removeColumn(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        this.internalCheckNotPrepared();
        this.m_aColumns.removeAtIndex(n);
        return (IMPLTYPE)((AbstractPLHBox)this.thisAsT());
    }

    @Override
    public final boolean isVertSplittable() {
        return this.m_bVertSplittable;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setVertSplittable(boolean bl) {
        this.m_bVertSplittable = bl;
        return (IMPLTYPE)((AbstractPLHBox)this.thisAsT());
    }

    public boolean containsAnyVertSplittableElement() {
        return this.m_aColumns.containsAny(pLHBoxColumn -> pLHBoxColumn.getElement().isVertSplittable());
    }

    @Override
    @Nonnull
    public EChange visit(@Nonnull IPLVisitor iPLVisitor) throws IOException {
        EChange eChange = EChange.UNCHANGED;
        for (PLHBoxColumn pLHBoxColumn : this.m_aColumns) {
            eChange = eChange.or((IChangeIndicator)pLHBoxColumn.getElement().visit(iPLVisitor));
        }
        return eChange;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected SizeSpec onPrepare(@Nonnull PreparationContext preparationContext) {
        float f;
        float f2;
        IPLRenderableObject<?> iPLRenderableObject;
        Object object;
        float f3;
        this.m_aPreparedColumnSizes = new SizeSpec[this.m_aColumns.size()];
        this.m_aPreparedElementSizes = new SizeSpec[this.m_aColumns.size()];
        float f4 = preparationContext.getAvailableWidth() - this.getOutlineXSum();
        float f5 = preparationContext.getAvailableHeight() - this.getOutlineYSum();
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        int n = 0;
        int n2 = 0;
        for (PLHBoxColumn pLHBoxColumn : this.m_aColumns) {
            switch (pLHBoxColumn.getWidth().getType()) {
                case STAR: {
                    ++n;
                    break;
                }
                case AUTO: {
                    ++n2;
                }
            }
        }
        int n3 = 0;
        float f9 = f4;
        for (PLHBoxColumn pLHBoxColumn : this.m_aColumns) {
            if (pLHBoxColumn.getWidth().isAbsolute()) {
                IPLRenderableObject<?> iPLRenderableObject2 = pLHBoxColumn.getElement();
                f3 = pLHBoxColumn.getWidth().getEffectiveValue(f4);
                object = iPLRenderableObject2.prepare(new PreparationContext(preparationContext.getGlobalContext(), f3, f5));
                f6 += f3;
                f9 -= f3;
                f8 = Math.max(f8, ((SizeSpec)object).getHeight());
                float f10 = ((SizeSpec)object).getHeight() + iPLRenderableObject2.getOutlineYSum();
                f7 = Math.max(f7, f10);
                this.m_aPreparedColumnSizes[n3] = new SizeSpec(f3, f10);
                this.m_aPreparedElementSizes[n3] = object;
            }
            ++n3;
        }
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = n2 + n == 0 ? 0.0f : f9 / (float)(n2 + n);
        f3 = f13 * (float)n2;
        object = new SizeSpec[this.m_aColumns.size()];
        n3 = 0;
        for (PLHBoxColumn pLHBoxColumn : this.m_aColumns) {
            if (pLHBoxColumn.getWidth().isAuto()) {
                iPLRenderableObject = pLHBoxColumn.getElement();
                SizeSpec sizeSpec = iPLRenderableObject.prepare(new PreparationContext(preparationContext.getGlobalContext(), f3, f5));
                f2 = sizeSpec.getWidth() + iPLRenderableObject.getOutlineXSum();
                if (f2 <= f13) {
                    f6 += f2;
                    f11 += f13 - f2;
                    f8 = Math.max(f8, sizeSpec.getHeight());
                    f = sizeSpec.getHeight() + iPLRenderableObject.getOutlineYSum();
                    f7 = Math.max(f7, f);
                    this.m_aPreparedColumnSizes[n3] = new SizeSpec(f2, f);
                    this.m_aPreparedElementSizes[n3] = sizeSpec;
                } else {
                    object[n3] = sizeSpec;
                    f11 += f13;
                    f12 += f2;
                }
            }
            ++n3;
        }
        n3 = 0;
        for (PLHBoxColumn pLHBoxColumn : this.m_aColumns) {
            if (pLHBoxColumn.getWidth().isAuto() && object[n3] != null) {
                iPLRenderableObject = pLHBoxColumn.getElement();
                float f14 = ((SizeSpec)object[n3]).getWidth() + iPLRenderableObject.getOutlineXSum();
                f2 = f12 == 0.0f ? 0.0f : f14 / f12;
                f = f11 * f2;
                if (iPLRenderableObject instanceof AbstractPLRenderableObject) {
                    ((AbstractPLRenderableObject)iPLRenderableObject).internalMarkAsNotPrepared();
                }
                SizeSpec sizeSpec = iPLRenderableObject.prepare(new PreparationContext(preparationContext.getGlobalContext(), f, f5));
                float f15 = sizeSpec.getWidth() + iPLRenderableObject.getOutlineXSum();
                f6 += f15;
                f8 = Math.max(f8, sizeSpec.getHeight());
                float f16 = sizeSpec.getHeight() + iPLRenderableObject.getOutlineYSum();
                f7 = Math.max(f7, f16);
                this.m_aPreparedColumnSizes[n3] = new SizeSpec(f15, f16);
                this.m_aPreparedElementSizes[n3] = sizeSpec;
            }
            ++n3;
        }
        f9 = f4 - f6;
        n3 = 0;
        for (PLHBoxColumn pLHBoxColumn : this.m_aColumns) {
            if (pLHBoxColumn.getWidth().isStar()) {
                IPLRenderableObject<?> iPLRenderableObject3 = pLHBoxColumn.getElement();
                if (n == 0) {
                    throw new IllegalStateException("Internal inconsistency");
                }
                f3 = f9 / (float)n;
                object = iPLRenderableObject3.prepare(new PreparationContext(preparationContext.getGlobalContext(), f3, f5));
                f6 += f3;
                f8 = Math.max(f8, ((SizeSpec)object).getHeight());
                float f17 = ((SizeSpec)object).getHeight() + iPLRenderableObject3.getOutlineYSum();
                f7 = Math.max(f7, f17);
                this.m_aPreparedColumnSizes[n3] = new SizeSpec(f3, f17);
                this.m_aPreparedElementSizes[n3] = object;
            }
            ++n3;
        }
        n3 = 0;
        for (PLHBoxColumn pLHBoxColumn : this.m_aColumns) {
            IPLRenderableObject<?> iPLRenderableObject4 = pLHBoxColumn.getElement();
            if (iPLRenderableObject4 instanceof AbstractPLElement) {
                AbstractPLElement abstractPLElement = (AbstractPLElement)iPLRenderableObject4;
                abstractPLElement.setMinSize(this.m_aPreparedColumnSizes[n3].getWidth() - abstractPLElement.getOutlineXSum(), f8);
            }
            ++n3;
        }
        if (PLDebugLog.isDebugPrepare()) {
            if ((double)(f6 - f4) > 0.01) {
                PLDebugLog.debugPrepare(this, "uses more width (" + f6 + ") than available (" + f4 + ")!");
            }
            if ((double)(f7 - f5) > 0.01 && !this.isVertSplittable()) {
                PLDebugLog.debugPrepare(this, "uses more height (" + f7 + ") than available (" + f5 + ")!");
            }
        }
        return new SizeSpec(f6, f7);
    }

    @Override
    protected void onMarkAsNotPrepared() {
        this.m_aPreparedColumnSizes = null;
        this.m_aPreparedElementSizes = null;
        for (PLHBoxColumn pLHBoxColumn : this.m_aColumns) {
            if (!(pLHBoxColumn.getElement() instanceof AbstractPLRenderableObject)) continue;
            ((AbstractPLRenderableObject)pLHBoxColumn.getElement()).internalMarkAsNotPrepared();
        }
    }

    @Nonnull
    protected AbstractPLRenderableObject<?> internalCreateVertSplitEmptyElement(@Nonnull IPLRenderableObject<?> iPLRenderableObject, float f, float f2) {
        return PLSpacerX.createPrepared(f, 0.0f);
    }

    @Override
    @Nullable
    public PLSplitResult splitElementVert(float f, float f2) {
        IPLRenderableObject<?> iPLRenderableObject;
        int n;
        SizeSpec[] sizeSpecArray;
        float f3;
        float f4;
        if (f2 <= 0.0f) {
            return null;
        }
        if (!this.containsAnyVertSplittableElement()) {
            if (PLDebugLog.isDebugSplit()) {
                PLDebugLog.debugSplit(this, "cannot split because no vertical splittable elements are contained");
            }
            return null;
        }
        int n2 = this.m_aColumns.size();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            IPLRenderableObject<?> iPLRenderableObject2 = this.getColumnElementAtIndex(i);
            if (!iPLRenderableObject2.isVertSplittable() || !((f4 = this.m_aPreparedColumnSizes[i].getHeight()) > f2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            if (PLDebugLog.isDebugSplit()) {
                PLDebugLog.debugSplit(this, "no need to split because all splittable elements easily fit into the available height (" + f2 + ")");
            }
            return null;
        }
        IPLSplittableObject iPLSplittableObject = ((AbstractPLHBox)((AbstractPLHBox)this.internalCreateNewVertSplitObject((AbstractPLHBox)this.thisAsT())).setID(this.getID() + "-1")).setVertSplittable(false);
        IPLSplittableObject iPLSplittableObject2 = ((AbstractPLHBox)((AbstractPLHBox)this.internalCreateNewVertSplitObject((AbstractPLHBox)this.thisAsT())).setID(this.getID() + "-2")).setVertSplittable(true);
        for (int i = 0; i < n2; ++i) {
            PLHBoxColumn pLHBoxColumn = this.getColumnAtIndex(i);
            WidthSpec widthSpec = pLHBoxColumn.getWidth();
            f3 = this.m_aPreparedColumnSizes[i].getWidth();
            float f5 = f2;
            sizeSpecArray = pLHBoxColumn.getElement();
            ((AbstractPLHBox)iPLSplittableObject).addColumn((IPLRenderableObject)this.internalCreateVertSplitEmptyElement((IPLRenderableObject<?>)sizeSpecArray, f3, f5).setID((String)sizeSpecArray.getID() + "-1"), widthSpec);
            ((AbstractPLHBox)iPLSplittableObject2).addColumn((IPLRenderableObject)this.internalCreateVertSplitEmptyElement((IPLRenderableObject<?>)sizeSpecArray, f3, f5).setID((String)sizeSpecArray.getID() + "-2"), widthSpec);
        }
        float f6 = 0.0f;
        f4 = 0.0f;
        float f7 = 0.0f;
        f3 = 0.0f;
        SizeSpec[] sizeSpecArray2 = new SizeSpec[this.m_aPreparedColumnSizes.length];
        sizeSpecArray = new SizeSpec[this.m_aPreparedColumnSizes.length];
        SizeSpec[] sizeSpecArray3 = new SizeSpec[this.m_aPreparedElementSizes.length];
        SizeSpec[] sizeSpecArray4 = new SizeSpec[this.m_aPreparedElementSizes.length];
        boolean bl2 = false;
        for (n = 0; n < n2; ++n) {
            iPLRenderableObject = this.getColumnElementAtIndex(n);
            boolean bl3 = iPLRenderableObject.isVertSplittable();
            float f8 = this.m_aPreparedColumnSizes[n].getWidth();
            float f9 = this.m_aPreparedColumnSizes[n].getHeight();
            float f10 = this.m_aPreparedElementSizes[n].getWidth();
            boolean bl4 = false;
            if (f9 > f2 && bl3) {
                PLSplitResult pLSplitResult;
                float f11 = f10;
                float f12 = f2 - iPLRenderableObject.getOutlineYSum();
                if (PLDebugLog.isDebugSplit()) {
                    PLDebugLog.debugSplit(this, "Trying to split " + iPLRenderableObject.getDebugID() + " with height " + f9 + " into pieces for remaining size " + PLDebugLog.getWH(f11, f12));
                }
                if ((pLSplitResult = iPLRenderableObject.getAsSplittable().splitElementVert(f11, f12)) != null) {
                    IPLRenderableObject<?> iPLRenderableObject3 = pLSplitResult.getFirstElement().getElement();
                    ((AbstractPLHBox)iPLSplittableObject).getColumnAtIndex(n).internalSetElement(iPLRenderableObject3);
                    IPLRenderableObject<?> iPLRenderableObject4 = pLSplitResult.getSecondElement().getElement();
                    ((AbstractPLHBox)iPLSplittableObject2).getColumnAtIndex(n).internalSetElement(iPLRenderableObject4);
                    sizeSpecArray2[n] = new SizeSpec(f8, pLSplitResult.getFirstElement().getHeightFull());
                    sizeSpecArray[n] = new SizeSpec(f8, pLSplitResult.getSecondElement().getHeightFull());
                    sizeSpecArray3[n] = new SizeSpec(f10, pLSplitResult.getFirstElement().getHeight());
                    sizeSpecArray4[n] = new SizeSpec(f10, pLSplitResult.getSecondElement().getHeight());
                    bl4 = true;
                    bl2 = true;
                    if (PLDebugLog.isDebugSplit()) {
                        PLDebugLog.debugSplit(this, "Split column element " + iPLRenderableObject.getDebugID() + " (Column " + n + ") into pieces: " + iPLRenderableObject3.getDebugID() + " (" + pLSplitResult.getFirstElement().getWidth() + "+" + iPLRenderableObject3.getOutlineXSum() + " & " + pLSplitResult.getFirstElement().getHeight() + "+" + iPLRenderableObject3.getOutlineYSum() + ") and " + iPLRenderableObject4.getDebugID() + " (" + pLSplitResult.getSecondElement().getWidth() + "+" + iPLRenderableObject4.getOutlineXSum() + " & " + pLSplitResult.getSecondElement().getHeight() + "+" + iPLRenderableObject4.getOutlineYSum() + ") for available height " + f2);
                    }
                } else if (PLDebugLog.isDebugSplit()) {
                    PLDebugLog.debugSplit(this, "Failed to split column element " + iPLRenderableObject.getDebugID() + " (Column " + n + ") with height " + f9 + " into pieces for available height " + f2);
                }
            }
            if (!bl4) {
                ((AbstractPLHBox)iPLSplittableObject).getColumnAtIndex(n).internalSetElement(iPLRenderableObject);
                sizeSpecArray2[n] = new SizeSpec(f8, iPLRenderableObject.getPreparedHeight() + iPLRenderableObject.getOutlineYSum());
                sizeSpecArray[n] = new SizeSpec(f8, 0.0f);
                sizeSpecArray3[n] = new SizeSpec(f10, iPLRenderableObject.getPreparedHeight());
                sizeSpecArray4[n] = new SizeSpec(f10, 0.0f);
            }
            f6 = Math.max(f6, sizeSpecArray3[n].getHeight());
            f4 = Math.max(f4, sizeSpecArray4[n].getHeight());
            f7 = Math.max(f7, sizeSpecArray2[n].getHeight());
            f3 = Math.max(f3, sizeSpecArray[n].getHeight());
        }
        if (!bl2) {
            if (PLDebugLog.isDebugSplit()) {
                PLDebugLog.debugSplit(this, "Weird: No column was split and the height is OK!");
            }
            return null;
        }
        for (n = 0; n < this.m_aColumns.size(); ++n) {
            IPLRenderableObject<Object> iPLRenderableObject5;
            iPLRenderableObject = ((AbstractPLHBox)iPLSplittableObject).getColumnElementAtIndex(n);
            if (iPLRenderableObject instanceof AbstractPLElement) {
                iPLRenderableObject5 = (AbstractPLElement)iPLRenderableObject;
                iPLRenderableObject5.setMinSize(this.m_aPreparedColumnSizes[n].getWidth() - iPLRenderableObject5.getOutlineXSum(), f6);
            }
            if (!((iPLRenderableObject5 = ((AbstractPLHBox)iPLSplittableObject2).getColumnElementAtIndex(n)) instanceof AbstractPLElement)) continue;
            IPLRenderableObject<Object> iPLRenderableObject6 = iPLRenderableObject5;
            iPLRenderableObject6.setMinSize(this.m_aPreparedColumnSizes[n].getWidth() - iPLRenderableObject6.getOutlineXSum(), f4);
        }
        ((AbstractPLRenderableObject)((Object)iPLSplittableObject)).internalMarkAsPrepared(new SizeSpec(f, f7));
        ((AbstractPLRenderableObject)((Object)iPLSplittableObject2)).internalMarkAsPrepared(new SizeSpec(f, f3));
        ((AbstractPLHBox)iPLSplittableObject).m_aPreparedColumnSizes = sizeSpecArray2;
        ((AbstractPLHBox)iPLSplittableObject2).m_aPreparedColumnSizes = sizeSpecArray;
        ((AbstractPLHBox)iPLSplittableObject).m_aPreparedElementSizes = sizeSpecArray3;
        ((AbstractPLHBox)iPLSplittableObject2).m_aPreparedElementSizes = sizeSpecArray4;
        return new PLSplitResult(new PLElementWithSize((IPLRenderableObject<?>)((Object)iPLSplittableObject), new SizeSpec(f, f7)), new PLElementWithSize((IPLRenderableObject<?>)((Object)iPLSplittableObject2), new SizeSpec(f, f3)));
    }

    @Override
    protected void onRender(@Nonnull PageRenderContext pageRenderContext) throws IOException {
        float f = pageRenderContext.getStartLeft();
        float f2 = pageRenderContext.getStartTop();
        int n = 0;
        for (PLHBoxColumn pLHBoxColumn : this.m_aColumns) {
            IPLRenderableObject<?> iPLRenderableObject = pLHBoxColumn.getElement();
            float f3 = this.m_aPreparedColumnSizes[n].getWidth();
            float f4 = this.m_aPreparedColumnSizes[n].getHeight();
            PageRenderContext pageRenderContext2 = new PageRenderContext(pageRenderContext, f, f2, f3, f4);
            iPLRenderableObject.render(pageRenderContext2);
            f += f3;
            ++n;
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Columns", this.m_aColumns).append("VertSplittable", this.m_bVertSplittable).appendIfNotNull("PreparedColumnSize", (Object)this.m_aPreparedColumnSizes).appendIfNotNull("PreparedElementSize", (Object)this.m_aPreparedElementSizes).getToString();
    }
}

