/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.table;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.math.MathHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public interface IPLCellRange {
    public int getFirstRow();

    public int getLastRow();

    public int getFirstColumn();

    public int getLastColumn();

    default public boolean isInRange(int n, int n2) {
        return this.containsRow(n) && this.containsColumn(n2);
    }

    default public boolean containsRow(int n) {
        return this.getFirstRow() <= n && n <= this.getLastRow();
    }

    default public boolean containsColumn(int n) {
        return this.getFirstColumn() <= n && n <= this.getLastColumn();
    }

    default public boolean intersects(@Nonnull IPLCellRange iPLCellRange) {
        ValueEnforcer.notNull((Object)iPLCellRange, (String)"Other");
        return this.getFirstRow() <= iPLCellRange.getLastRow() && this.getFirstColumn() <= iPLCellRange.getLastColumn() && iPLCellRange.getFirstRow() <= this.getLastRow() && iPLCellRange.getFirstColumn() <= this.getLastColumn();
    }

    @Nonnegative
    default public int getRowCount() {
        return Math.max(this.getLastRow() - this.getFirstRow() + 1, 0);
    }

    @Nonnegative
    default public int getColumnCount() {
        return Math.max(this.getLastColumn() - this.getFirstColumn() + 1, 0);
    }

    default public long getNumberOfCells() {
        return MathHelper.abs((long)((long)this.getRowCount() * (long)this.getColumnCount()));
    }

    default public int getMinRow() {
        return Math.min(this.getFirstRow(), this.getLastRow());
    }

    default public int getMaxRow() {
        return Math.max(this.getFirstRow(), this.getLastRow());
    }

    default public int getMinColumn() {
        return Math.min(this.getFirstColumn(), this.getLastColumn());
    }

    default public int getMaxColumn() {
        return Math.max(this.getFirstColumn(), this.getLastColumn());
    }
}

