/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.pdfbox;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.collection.NonBlockingStack;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentHelper;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDInlineImage;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.util.Charsets;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.NumberFormatUtil;

@CodingStyleguideUnaware
@NotThreadSafe
public final class PDPageContentStreamExt
implements Closeable {
    private static final Log LOGGER = LogFactory.getLog(PDPageContentStreamExt.class);
    private final PDDocument m_aDoc;
    protected OutputStream m_aOS;
    private PDResources m_aResources;
    private boolean m_bInTextMode = false;
    private final NonBlockingStack<PDFont> m_aFontStack = new NonBlockingStack();
    private final NonBlockingStack<PDColorSpace> m_aNonStrokingColorSpaceStack = new NonBlockingStack();
    private final NonBlockingStack<PDColorSpace> m_aStrokingColorSpaceStack = new NonBlockingStack();
    private final NumberFormat m_aFormatDecimal = NumberFormat.getNumberInstance(Locale.US);
    private final byte[] m_aFormatBuffer = new byte[32];

    public PDPageContentStreamExt(PDDocument pDDocument, PDPage pDPage) throws IOException {
        this(pDDocument, pDPage, PDPageContentStream.AppendMode.OVERWRITE, true);
    }

    public PDPageContentStreamExt(PDDocument pDDocument, PDPage pDPage, PDPageContentStream.AppendMode appendMode, boolean bl) throws IOException {
        this(pDDocument, pDPage, appendMode, bl, false);
    }

    public PDPageContentStreamExt(PDDocument pDDocument, PDPage pDPage, PDPageContentStream.AppendMode appendMode, boolean bl, boolean bl2) throws IOException {
        COSName cOSName;
        this.m_aDoc = pDDocument;
        Object object = cOSName = bl ? COSName.FLATE_DECODE : null;
        if (!appendMode.isOverwrite() && pDPage.hasContents()) {
            COSArray cOSArray;
            PDStream pDStream = new PDStream(pDDocument);
            COSBase cOSBase = pDPage.getCOSObject().getDictionaryObject(COSName.CONTENTS);
            if (cOSBase instanceof COSArray) {
                cOSArray = (COSArray)cOSBase;
            } else {
                cOSArray = new COSArray();
                cOSArray.add(cOSBase);
            }
            if (appendMode.isPrepend()) {
                cOSArray.add(0, (COSBase)pDStream.getCOSObject());
            } else {
                cOSArray.add((COSObjectable)pDStream);
            }
            if (bl2) {
                PDStream pDStream2 = new PDStream(pDDocument);
                this.m_aOS = pDStream2.createOutputStream(cOSName);
                this.saveGraphicsState();
                this.close();
                cOSArray.add(0, (COSBase)pDStream2.getCOSObject());
            }
            pDPage.getCOSObject().setItem(COSName.CONTENTS, (COSBase)cOSArray);
            this.m_aOS = pDStream.createOutputStream(cOSName);
            if (bl2) {
                this.restoreGraphicsState();
            }
        } else {
            if (pDPage.hasContents()) {
                LOGGER.warn((Object)"You are overwriting an existing content, you should use the append mode");
            }
            PDStream pDStream = new PDStream(pDDocument);
            pDPage.setContents(pDStream);
            this.m_aOS = pDStream.createOutputStream(cOSName);
        }
        this.m_aResources = pDPage.getResources();
        if (this.m_aResources == null) {
            this.m_aResources = new PDResources();
            pDPage.setResources(this.m_aResources);
        }
        this.m_aFormatDecimal.setMaximumFractionDigits(5);
        this.m_aFormatDecimal.setGroupingUsed(false);
    }

    public PDPageContentStreamExt(PDDocument pDDocument, PDAppearanceStream pDAppearanceStream) throws IOException {
        this(pDDocument, pDAppearanceStream, pDAppearanceStream.getStream().createOutputStream());
    }

    public PDPageContentStreamExt(PDDocument pDDocument, PDAppearanceStream pDAppearanceStream, OutputStream outputStream) {
        this.m_aDoc = pDDocument;
        this.m_aOS = outputStream;
        this.m_aResources = pDAppearanceStream.getResources();
        this.m_aFormatDecimal.setMaximumFractionDigits(4);
        this.m_aFormatDecimal.setGroupingUsed(false);
    }

    @Nonnull
    final OutputStream getOutput() {
        return this.m_aOS;
    }

    public void beginText() throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: Nested beginText() calls are not allowed.");
        }
        this.writeOperator(66, 84);
        this.m_bInTextMode = true;
    }

    public void endText() throws IOException {
        if (!this.m_bInTextMode) {
            throw new IllegalStateException("Error: You must call beginText() before calling endText.");
        }
        this.writeOperator(69, 84);
        this.m_bInTextMode = false;
    }

    public void setFont(PDFont pDFont, float f) throws IOException {
        if (this.m_aFontStack.isEmpty()) {
            this.m_aFontStack.add((Object)pDFont);
        } else {
            this.m_aFontStack.set(this.m_aFontStack.size() - 1, (Object)pDFont);
        }
        PDDocumentHelper.handleFontSubset(this.m_aDoc, pDFont);
        this.writeOperand(this.m_aResources.add(pDFont));
        this.writeOperand(f);
        this.writeOperator(84, 102);
    }

    public void setCharacterSpacing(float f) throws IOException {
        this.writeOperand(f);
        this.writeOperator(84, 99);
    }

    public void showText(String string) throws IOException {
        if (!this.m_bInTextMode) {
            throw new IllegalStateException("Must call beginText() before showText()");
        }
        if (this.m_aFontStack.isEmpty()) {
            throw new IllegalStateException("Must call setFont() before showText()");
        }
        PDFont pDFont = (PDFont)this.m_aFontStack.peek();
        if (pDFont.willBeSubset()) {
            int n;
            for (int i = 0; i < string.length(); i += Character.charCount(n)) {
                n = string.codePointAt(i);
                pDFont.addToSubset(n);
            }
        }
        COSWriter.writeString((byte[])pDFont.encode(string), (OutputStream)this.m_aOS);
        this.write(32);
        this.writeOperator(84, 106);
    }

    public void setLeading(double d) throws IOException {
        this.writeOperand((float)d);
        this.writeOperator(84, 76);
    }

    public void newLine() throws IOException {
        if (!this.m_bInTextMode) {
            throw new IllegalStateException("Must call beginText() before newLine()");
        }
        this.writeOperator(84, 42);
    }

    public void newLineAtOffset(float f, float f2) throws IOException {
        if (!this.m_bInTextMode) {
            throw new IllegalStateException("Error: must call beginText() before newLineAtOffset()");
        }
        this.writeOperand(f);
        this.writeOperand(f2);
        this.writeOperator(84, 100);
    }

    public void setTextMatrix(Matrix matrix) throws IOException {
        if (!this.m_bInTextMode) {
            throw new IllegalStateException("Error: must call beginText() before setTextMatrix");
        }
        this.writeAffineTransform(matrix.createAffineTransform());
        this.writeOperator(84, 109);
    }

    public void drawImage(PDImageXObject pDImageXObject, float f, float f2) throws IOException {
        this.drawImage(pDImageXObject, f, f2, (float)pDImageXObject.getWidth(), (float)pDImageXObject.getHeight());
    }

    public void drawImage(PDImageXObject pDImageXObject, float f, float f2, float f3, float f4) throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: drawImage is not allowed within a text block.");
        }
        this.saveGraphicsState();
        AffineTransform affineTransform = new AffineTransform(f3, 0.0f, 0.0f, f4, f, f2);
        this.transform(new Matrix(affineTransform));
        this.writeOperand(this.m_aResources.add(pDImageXObject));
        this.writeOperator(68, 111);
        this.restoreGraphicsState();
    }

    public void drawImage(PDInlineImage pDInlineImage, float f, float f2) throws IOException {
        this.drawImage(pDInlineImage, f, f2, (float)pDInlineImage.getWidth(), (float)pDInlineImage.getHeight());
    }

    public void drawImage(PDInlineImage pDInlineImage, float f, float f2, float f3, float f4) throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: drawImage is not allowed within a text block.");
        }
        this.saveGraphicsState();
        this.transform(new Matrix(f3, 0.0f, 0.0f, f4, f, f2));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BI");
        stringBuilder.append("\n /W ");
        stringBuilder.append(pDInlineImage.getWidth());
        stringBuilder.append("\n /H ");
        stringBuilder.append(pDInlineImage.getHeight());
        stringBuilder.append("\n /CS ");
        stringBuilder.append("/");
        stringBuilder.append(pDInlineImage.getColorSpace().getName());
        if (pDInlineImage.getDecode() != null && pDInlineImage.getDecode().size() > 0) {
            stringBuilder.append("\n /D ");
            stringBuilder.append("[");
            for (COSBase cOSBase : pDInlineImage.getDecode()) {
                stringBuilder.append(((COSNumber)cOSBase).intValue());
                stringBuilder.append(" ");
            }
            stringBuilder.append("]");
        }
        if (pDInlineImage.isStencil()) {
            stringBuilder.append("\n /IM true");
        }
        stringBuilder.append("\n /BPC ");
        stringBuilder.append(pDInlineImage.getBitsPerComponent());
        this.write(stringBuilder.toString());
        this.writeLine();
        this.writeOperator(73, 68);
        this.writeBytes(pDInlineImage.getData());
        this.writeLine();
        this.writeOperator(69, 73);
        this.restoreGraphicsState();
    }

    public void drawForm(PDFormXObject pDFormXObject) throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: drawForm is not allowed within a text block.");
        }
        this.writeOperand(this.m_aResources.add(pDFormXObject));
        this.writeOperator(68, 111);
    }

    public void transform(Matrix matrix) throws IOException {
        this.writeAffineTransform(matrix.createAffineTransform());
        this.writeOperator(99, 109);
    }

    public void saveGraphicsState() throws IOException {
        if (!this.m_aFontStack.isEmpty()) {
            this.m_aFontStack.push((Object)((PDFont)this.m_aFontStack.peek()));
        }
        if (!this.m_aStrokingColorSpaceStack.isEmpty()) {
            this.m_aStrokingColorSpaceStack.push((Object)((PDColorSpace)this.m_aStrokingColorSpaceStack.peek()));
        }
        if (!this.m_aNonStrokingColorSpaceStack.isEmpty()) {
            this.m_aNonStrokingColorSpaceStack.push((Object)((PDColorSpace)this.m_aNonStrokingColorSpaceStack.peek()));
        }
        this.writeOperator(113);
    }

    public void restoreGraphicsState() throws IOException {
        if (!this.m_aFontStack.isEmpty()) {
            this.m_aFontStack.pop();
        }
        if (!this.m_aStrokingColorSpaceStack.isEmpty()) {
            this.m_aStrokingColorSpaceStack.pop();
        }
        if (!this.m_aNonStrokingColorSpaceStack.isEmpty()) {
            this.m_aNonStrokingColorSpaceStack.pop();
        }
        this.writeOperator(81);
    }

    private COSName getName(PDColorSpace pDColorSpace) {
        if (pDColorSpace instanceof PDDeviceGray || pDColorSpace instanceof PDDeviceRGB || pDColorSpace instanceof PDDeviceCMYK) {
            return COSName.getPDFName((String)pDColorSpace.getName());
        }
        return this.m_aResources.add(pDColorSpace);
    }

    public void setStrokingColor(@Nonnull PDColor pDColor) throws IOException {
        if (this.m_aStrokingColorSpaceStack.isEmpty() || this.m_aStrokingColorSpaceStack.peek() != pDColor.getColorSpace()) {
            this.writeOperand(this.getName(pDColor.getColorSpace()));
            this.writeOperator(67, 83);
            if (this.m_aStrokingColorSpaceStack.isEmpty()) {
                this.m_aStrokingColorSpaceStack.add((Object)pDColor.getColorSpace());
            } else {
                this.m_aStrokingColorSpaceStack.set(this.m_aNonStrokingColorSpaceStack.size() - 1, (Object)pDColor.getColorSpace());
            }
        }
        for (float f : pDColor.getComponents()) {
            this.writeOperand(f);
        }
        if (pDColor.getColorSpace() instanceof PDPattern) {
            this.writeOperand(pDColor.getPatternName());
        }
        if (pDColor.getColorSpace() instanceof PDPattern || pDColor.getColorSpace() instanceof PDSeparation || pDColor.getColorSpace() instanceof PDDeviceN || pDColor.getColorSpace() instanceof PDICCBased) {
            this.writeOperator(83, 67, 78);
        } else {
            this.writeOperator(83, 67);
        }
    }

    public void setStrokingColor(@Nonnull Color color) throws IOException {
        float[] fArray = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
        PDColor pDColor = new PDColor(fArray, (PDColorSpace)PDDeviceRGB.INSTANCE);
        this.setStrokingColor(pDColor);
    }

    public void setStrokingColor(int n, int n2, int n3) throws IOException {
        if (PDPageContentStreamExt._isOutside255Interval(n) || PDPageContentStreamExt._isOutside255Interval(n2) || PDPageContentStreamExt._isOutside255Interval(n3)) {
            throw new IllegalArgumentException("Parameters must be within 0..255, but are (" + n + "," + n2 + "," + n3 + ")");
        }
        this.writeOperand((float)n / 255.0f);
        this.writeOperand((float)n2 / 255.0f);
        this.writeOperand((float)n3 / 255.0f);
        this.writeOperator(82, 71);
    }

    public void setStrokingColor(float f, float f2, float f3, float f4) throws IOException {
        if (PDPageContentStreamExt._isOutsideOneInterval(f) || PDPageContentStreamExt._isOutsideOneInterval(f2) || PDPageContentStreamExt._isOutsideOneInterval(f3) || PDPageContentStreamExt._isOutsideOneInterval(f4)) {
            throw new IllegalArgumentException("Parameters must be within 0..1, but are (" + f + "," + f2 + "," + f3 + "," + f4 + ")");
        }
        this.writeOperand(f);
        this.writeOperand(f2);
        this.writeOperand(f3);
        this.writeOperand(f4);
        this.writeOperator(75);
    }

    public void setStrokingColor(double d) throws IOException {
        if (PDPageContentStreamExt._isOutsideOneInterval(d)) {
            throw new IllegalArgumentException("Parameter must be within 0..1, but is " + d);
        }
        this.writeOperand((float)d);
        this.writeOperator(71);
    }

    public void setNonStrokingColor(@Nonnull PDColor pDColor) throws IOException {
        if (this.m_aNonStrokingColorSpaceStack.isEmpty() || this.m_aNonStrokingColorSpaceStack.peek() != pDColor.getColorSpace()) {
            this.writeOperand(this.getName(pDColor.getColorSpace()));
            this.writeOperator(99, 115);
            if (this.m_aNonStrokingColorSpaceStack.isEmpty()) {
                this.m_aNonStrokingColorSpaceStack.add((Object)pDColor.getColorSpace());
            } else {
                this.m_aNonStrokingColorSpaceStack.set(this.m_aNonStrokingColorSpaceStack.size() - 1, (Object)pDColor.getColorSpace());
            }
        }
        for (float f : pDColor.getComponents()) {
            this.writeOperand(f);
        }
        if (pDColor.getColorSpace() instanceof PDPattern) {
            this.writeOperand(pDColor.getPatternName());
        }
        if (pDColor.getColorSpace() instanceof PDPattern || pDColor.getColorSpace() instanceof PDSeparation || pDColor.getColorSpace() instanceof PDDeviceN || pDColor.getColorSpace() instanceof PDICCBased) {
            this.writeOperator(115, 99, 110);
        } else {
            this.writeOperator(115, 99);
        }
    }

    public void setNonStrokingColor(@Nonnull Color color) throws IOException {
        float[] fArray = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
        PDColor pDColor = new PDColor(fArray, (PDColorSpace)PDDeviceRGB.INSTANCE);
        this.setNonStrokingColor(pDColor);
    }

    public void setNonStrokingColor(int n, int n2, int n3) throws IOException {
        if (PDPageContentStreamExt._isOutside255Interval(n) || PDPageContentStreamExt._isOutside255Interval(n2) || PDPageContentStreamExt._isOutside255Interval(n3)) {
            throw new IllegalArgumentException("Parameters must be within 0..255, but are (" + n + "," + n2 + "," + n3 + ")");
        }
        this.writeOperand((float)n / 255.0f);
        this.writeOperand((float)n2 / 255.0f);
        this.writeOperand((float)n3 / 255.0f);
        this.writeOperator(114, 103);
    }

    public void setNonStrokingColor(int n, int n2, int n3, int n4) throws IOException {
        if (PDPageContentStreamExt._isOutside255Interval(n) || PDPageContentStreamExt._isOutside255Interval(n2) || PDPageContentStreamExt._isOutside255Interval(n3) || PDPageContentStreamExt._isOutside255Interval(n4)) {
            throw new IllegalArgumentException("Parameters must be within 0..255, but are (" + n + "," + n2 + "," + n3 + "," + n4 + ")");
        }
        this.setNonStrokingColor((float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, (float)n4 / 255.0f);
    }

    public void setNonStrokingColor(double d, double d2, double d3, double d4) throws IOException {
        if (PDPageContentStreamExt._isOutsideOneInterval(d) || PDPageContentStreamExt._isOutsideOneInterval(d2) || PDPageContentStreamExt._isOutsideOneInterval(d3) || PDPageContentStreamExt._isOutsideOneInterval(d4)) {
            throw new IllegalArgumentException("Parameters must be within 0..1, but are (" + d + "," + d2 + "," + d3 + "," + d4 + ")");
        }
        this.writeOperand((float)d);
        this.writeOperand((float)d2);
        this.writeOperand((float)d3);
        this.writeOperand((float)d4);
        this.writeOperator(107);
    }

    public void setNonStrokingColor(int n) throws IOException {
        if (PDPageContentStreamExt._isOutside255Interval(n)) {
            throw new IllegalArgumentException("Parameter must be within 0..255, but is " + n);
        }
        this.setNonStrokingColor((float)n / 255.0f);
    }

    public void setNonStrokingColor(double d) throws IOException {
        if (PDPageContentStreamExt._isOutsideOneInterval(d)) {
            throw new IllegalArgumentException("Parameter must be within 0..1, but is " + d);
        }
        this.writeOperand((float)d);
        this.writeOperator(103);
    }

    public void addRect(float f, float f2, float f3, float f4) throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: addRect is not allowed within a text block.");
        }
        this.writeOperand(f);
        this.writeOperand(f2);
        this.writeOperand(f3);
        this.writeOperand(f4);
        this.writeOperator(114, 101);
    }

    public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: curveTo is not allowed within a text block.");
        }
        this.writeOperand(f);
        this.writeOperand(f2);
        this.writeOperand(f3);
        this.writeOperand(f4);
        this.writeOperand(f5);
        this.writeOperand(f6);
        this.writeOperator(99);
    }

    public void curveTo2(float f, float f2, float f3, float f4) throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: curveTo2 is not allowed within a text block.");
        }
        this.writeOperand(f);
        this.writeOperand(f2);
        this.writeOperand(f3);
        this.writeOperand(f4);
        this.writeOperator(118);
    }

    public void curveTo1(float f, float f2, float f3, float f4) throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: curveTo1 is not allowed within a text block.");
        }
        this.writeOperand(f);
        this.writeOperand(f2);
        this.writeOperand(f3);
        this.writeOperand(f4);
        this.writeOperator(121);
    }

    public void moveTo(float f, float f2) throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: moveTo is not allowed within a text block.");
        }
        this.writeOperand(f);
        this.writeOperand(f2);
        this.writeOperator(109);
    }

    public void lineTo(float f, float f2) throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: lineTo is not allowed within a text block.");
        }
        this.writeOperand(f);
        this.writeOperand(f2);
        this.writeOperator(108);
    }

    public void stroke() throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: stroke is not allowed within a text block.");
        }
        this.writeOperator(83);
    }

    public void closeAndStroke() throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: closeAndStroke is not allowed within a text block.");
        }
        this.writeOperator(115);
    }

    public void fill() throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: fill is not allowed within a text block.");
        }
        this.writeOperator(102);
    }

    public void fillEvenOdd() throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: fill is not allowed within a text block.");
        }
        this.writeOperator(102, 42);
    }

    public void shadingFill(PDShading pDShading) throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: shadingFill is not allowed within a text block.");
        }
        this.writeOperand(this.m_aResources.add(pDShading));
        this.writeOperator(115, 104);
    }

    public void closePath() throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: closePath is not allowed within a text block.");
        }
        this.writeOperator(104);
    }

    public void clip() throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: clip is not allowed within a text block.");
        }
        this.writeOperator(87);
        this.writeOperator(110);
    }

    public void clipEvenOdd() throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: clipEvenOdd is not allowed within a text block.");
        }
        this.writeOperator(87, 42);
        this.writeOperator(110);
    }

    public void setLineWidth(float f) throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: setLineWidth is not allowed within a text block.");
        }
        this.writeOperand(f);
        this.writeOperator(119);
    }

    public void setLineJoinStyle(int n) throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: setLineJoinStyle is not allowed within a text block.");
        }
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Error: unknown value for line join style");
        }
        this.writeOperand(n);
        this.writeOperator(106);
    }

    public void setLineCapStyle(int n) throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: setLineCapStyle is not allowed within a text block.");
        }
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Error: unknown value for line cap style");
        }
        this.writeOperand(n);
        this.writeOperator(74);
    }

    public void setLineDashPattern(float[] fArray, float f) throws IOException {
        if (this.m_bInTextMode) {
            throw new IllegalStateException("Error: setLineDashPattern is not allowed within a text block.");
        }
        this.write(91);
        for (float f2 : fArray) {
            this.writeOperand(f2);
        }
        this.write(93, 32);
        this.writeOperand(f);
        this.writeOperator(100);
    }

    public void beginMarkedContent(COSName cOSName) throws IOException {
        this.writeOperand(cOSName);
        this.writeOperator(66, 77, 67);
    }

    public void beginMarkedContent(COSName cOSName, PDPropertyList pDPropertyList) throws IOException {
        this.writeOperand(cOSName);
        this.writeOperand(this.m_aResources.add(pDPropertyList));
        this.writeOperator(66, 68, 67);
    }

    public void endMarkedContent() throws IOException {
        this.writeOperator(69, 77, 67);
    }

    public void setGraphicsStateParameters(PDExtendedGraphicsState pDExtendedGraphicsState) throws IOException {
        this.writeOperand(this.m_aResources.add(pDExtendedGraphicsState));
        this.writeOperator(103, 115);
    }

    protected void writeOperand(float f) throws IOException {
        int n = NumberFormatUtil.formatFloatFast((float)f, (int)this.m_aFormatDecimal.getMaximumFractionDigits(), (byte[])this.m_aFormatBuffer);
        if (n == -1) {
            this.write(this.m_aFormatDecimal.format(f));
        } else {
            this.m_aOS.write(this.m_aFormatBuffer, 0, n);
        }
        this.m_aOS.write(32);
    }

    protected void writeOperand(int n) throws IOException {
        this.write(this.m_aFormatDecimal.format(n));
        this.m_aOS.write(32);
    }

    protected void writeOperand(COSName cOSName) throws IOException {
        cOSName.writePDF(this.m_aOS);
        this.m_aOS.write(32);
    }

    protected final void writeOperator(byte ... byArray) throws IOException {
        this.m_aOS.write(byArray);
        this.m_aOS.write(10);
    }

    private void write(String string) throws IOException {
        this.write(string.getBytes(Charsets.US_ASCII));
    }

    protected void write(byte ... byArray) throws IOException {
        this.m_aOS.write(byArray);
    }

    protected void writeLine() throws IOException {
        this.m_aOS.write(10);
    }

    protected void writeBytes(byte[] byArray) throws IOException {
        this.m_aOS.write(byArray);
    }

    private void writeAffineTransform(AffineTransform affineTransform) throws IOException {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        for (double d : dArray) {
            this.writeOperand((float)d);
        }
    }

    @Override
    public void close() throws IOException {
        this.m_aOS.close();
    }

    private static boolean _isOutside255Interval(int n) {
        return n < 0 || n > 255;
    }

    private static boolean _isOutsideOneInterval(double d) {
        return d < 0.0 || d > 1.0;
    }
}

