/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.spec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public abstract class AbstractRectSpec
implements Serializable {
    protected final float m_fTop;
    protected final float m_fRight;
    protected final float m_fBottom;
    protected final float m_fLeft;
    private final float m_fXSum;
    private final float m_fYSum;

    public AbstractRectSpec(@Nonnull AbstractRectSpec abstractRectSpec) {
        this(abstractRectSpec.m_fTop, abstractRectSpec.m_fRight, abstractRectSpec.m_fBottom, abstractRectSpec.m_fLeft);
    }

    public AbstractRectSpec(float f, float f2, float f3, float f4) {
        ValueEnforcer.isFalse((boolean)Float.isNaN(f), (String)"Top may not be NaN");
        ValueEnforcer.isFalse((boolean)Float.isNaN(f2), (String)"Right may not be NaN");
        ValueEnforcer.isFalse((boolean)Float.isNaN(f3), (String)"Bottom may not be NaN");
        ValueEnforcer.isFalse((boolean)Float.isNaN(f4), (String)"Left may not be NaN");
        this.m_fTop = f;
        this.m_fRight = f2;
        this.m_fBottom = f3;
        this.m_fLeft = f4;
        this.m_fXSum = f4 + f2;
        this.m_fYSum = f + f3;
    }

    public final boolean hasAnyValue() {
        return this.m_fTop != 0.0f || this.m_fRight != 0.0f || this.m_fBottom != 0.0f || this.m_fLeft != 0.0f;
    }

    public final float getTop() {
        return this.m_fTop;
    }

    public final float getRight() {
        return this.m_fRight;
    }

    public final float getBottom() {
        return this.m_fBottom;
    }

    public final float getLeft() {
        return this.m_fLeft;
    }

    public final float getXSum() {
        return this.m_fXSum;
    }

    public final float getYSum() {
        return this.m_fYSum;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractRectSpec abstractRectSpec = (AbstractRectSpec)object;
        return EqualsHelper.equals((float)this.m_fTop, (float)abstractRectSpec.m_fTop) && EqualsHelper.equals((float)this.m_fRight, (float)abstractRectSpec.m_fRight) && EqualsHelper.equals((float)this.m_fBottom, (float)abstractRectSpec.m_fBottom) && EqualsHelper.equals((float)this.m_fLeft, (float)abstractRectSpec.m_fLeft);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_fTop).append(this.m_fRight).append(this.m_fBottom).append(this.m_fLeft).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Top", this.m_fTop).append("Right", this.m_fRight).append("Bottom", this.m_fBottom).append("Left", this.m_fLeft).append("XSum", this.m_fXSum).append("YSum", this.m_fYSum).getToString();
    }
}

