/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.spec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.IHasID;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.font.api.IFontResource;
import com.helger.pdflayout.debug.PLDebugLog;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

@NotThreadSafe
public final class PreloadFont
implements IHasID<String>,
Serializable {
    private static final int DEFAULT_FALLBACK_CODE_POINT = 63;
    private static final ICommonsOrderedMap<String, PDType1Font> STANDARD_14 = new CommonsLinkedHashMap();
    private static final ICommonsOrderedMap<String, PreloadFont> STANDARD_14_PF = new CommonsLinkedHashMap();
    public static final PreloadFont REGULAR = PreloadFont._createPredefined(PDType1Font.HELVETICA);
    public static final PreloadFont REGULAR_BOLD = PreloadFont._createPredefined(PDType1Font.HELVETICA_BOLD);
    public static final PreloadFont REGULAR_ITALIC = PreloadFont._createPredefined(PDType1Font.HELVETICA_OBLIQUE);
    public static final PreloadFont REGULAR_BOLD_ITALIC = PreloadFont._createPredefined(PDType1Font.HELVETICA_BOLD_OBLIQUE);
    public static final PreloadFont MONOSPACE = PreloadFont._createPredefined(PDType1Font.COURIER);
    public static final PreloadFont MONOSPACE_BOLD = PreloadFont._createPredefined(PDType1Font.COURIER_BOLD);
    public static final PreloadFont MONOSPACE_ITALIC = PreloadFont._createPredefined(PDType1Font.COURIER_OBLIQUE);
    public static final PreloadFont MONOSPACE_BOLD_ITALIC = PreloadFont._createPredefined(PDType1Font.COURIER_BOLD_OBLIQUE);
    public static final PreloadFont TIMES = PreloadFont._createPredefined(PDType1Font.TIMES_ROMAN);
    public static final PreloadFont TIMES_BOLD = PreloadFont._createPredefined(PDType1Font.TIMES_BOLD);
    public static final PreloadFont TIMES_ITALIC = PreloadFont._createPredefined(PDType1Font.TIMES_ITALIC);
    public static final PreloadFont TIMES_BOLD_ITALIC = PreloadFont._createPredefined(PDType1Font.TIMES_BOLD_ITALIC);
    public static final PreloadFont SYMBOL = PreloadFont._createPredefined(PDType1Font.SYMBOL);
    public static final PreloadFont ZAPF_DINGBATS = PreloadFont._createPredefined(PDType1Font.ZAPF_DINGBATS);
    private String m_sID;
    private PDFont m_aFont;
    private IFontResource m_aFontRes;
    private boolean m_bEmbed;
    private int m_nFallbackCodePoint;
    private transient TrueTypeFont m_aTTF;
    private transient OpenTypeFont m_aOTF;

    @Nonnull
    private static PreloadFont _createPredefined(@Nonnull PDType1Font pDType1Font) {
        ValueEnforcer.notNull((Object)pDType1Font, (String)"Font");
        int n = pDType1Font == PDType1Font.SYMBOL ? 8226 : (pDType1Font == PDType1Font.ZAPF_DINGBATS ? 10005 : 63);
        PreloadFont preloadFont = new PreloadFont((PDFont)pDType1Font, n);
        STANDARD_14.put((Object)pDType1Font.getBaseFont(), (Object)pDType1Font);
        STANDARD_14_PF.put((Object)pDType1Font.getBaseFont(), (Object)preloadFont);
        return preloadFont;
    }

    private void _parseFontRes() throws IOException {
        if (this.m_aFontRes != null) {
            switch (this.m_aFontRes.getFontType()) {
                case TTF: {
                    if (PLDebugLog.isDebugFont()) {
                        PLDebugLog.debugFont(this.m_aFontRes.toString(), "Loading TTF font");
                    }
                    this.m_aTTF = new TTFParser().parse(this.m_aFontRes.getInputStream());
                    break;
                }
                case OTF: {
                    if (PLDebugLog.isDebugFont()) {
                        PLDebugLog.debugFont(this.m_aFontRes.toString(), "Loading OTF font");
                    }
                    this.m_aOTF = new OTFParser().parse(this.m_aFontRes.getInputStream());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot parse font resources of type " + this.m_aFontRes.getFontType());
                }
            }
        }
    }

    private void readObject(@Nonnull @WillNotClose ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.m_sID = StreamHelper.readSafeUTF((DataInput)objectInputStream);
        String string = StreamHelper.readSafeUTF((DataInput)objectInputStream);
        this.m_aFont = (PDFont)STANDARD_14.get((Object)string);
        this.m_aFontRes = (IFontResource)objectInputStream.readObject();
        this.m_bEmbed = objectInputStream.readBoolean();
        this.m_nFallbackCodePoint = objectInputStream.readInt();
        this._parseFontRes();
    }

    private void writeObject(@Nonnull @WillNotClose ObjectOutputStream objectOutputStream) throws IOException {
        StreamHelper.writeSafeUTF((DataOutput)objectOutputStream, (String)this.m_sID);
        StreamHelper.writeSafeUTF((DataOutput)objectOutputStream, this.m_aFont != null ? this.m_aFont.getName() : null);
        objectOutputStream.writeObject(this.m_aFontRes);
        objectOutputStream.writeBoolean(this.m_bEmbed);
        objectOutputStream.writeInt(this.m_nFallbackCodePoint);
    }

    private PreloadFont(@Nonnull PDFont pDFont, int n) {
        ValueEnforcer.notNull((Object)pDFont, (String)"Font");
        this.m_sID = pDFont.getName();
        this.m_aFont = pDFont;
        this.m_aFontRes = null;
        this.m_bEmbed = false;
        this.m_nFallbackCodePoint = n;
    }

    private PreloadFont(@Nonnull IFontResource iFontResource, boolean bl, int n) throws IOException {
        ValueEnforcer.notNull((Object)iFontResource, (String)"FontResource");
        this.m_sID = (String)iFontResource.getID();
        this.m_aFont = null;
        this.m_aFontRes = iFontResource;
        this.m_bEmbed = bl;
        this.m_nFallbackCodePoint = n;
        this._parseFontRes();
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public PDFont loadPDFont(@Nonnull PDDocument pDDocument) throws IOException {
        if (this.m_aFont != null) {
            return this.m_aFont;
        }
        PDType0Font pDType0Font = null;
        if (this.m_aTTF != null) {
            pDType0Font = PDType0Font.load((PDDocument)pDDocument, (TrueTypeFont)this.m_aTTF, (boolean)this.m_bEmbed);
        } else if (this.m_aOTF != null) {
            pDType0Font = PDType0Font.load((PDDocument)pDDocument, (TrueTypeFont)this.m_aOTF, (boolean)this.m_bEmbed);
        }
        if (pDType0Font == null) {
            throw new IllegalArgumentException("Cannot load font resources of type " + this.m_aFontRes.getFontType());
        }
        return pDType0Font;
    }

    public int getFallbackCodePoint() {
        return this.m_nFallbackCodePoint;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PreloadFont preloadFont = (PreloadFont)object;
        return EqualsHelper.equals((Object)this.m_aFont, (Object)preloadFont.m_aFont) && EqualsHelper.equals((Object)this.m_aFontRes, (Object)preloadFont.m_aFontRes) && this.m_bEmbed == preloadFont.m_bEmbed && this.m_nFallbackCodePoint == preloadFont.m_nFallbackCodePoint;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aFont).append((Object)this.m_aFontRes).append(this.m_bEmbed).append(this.m_nFallbackCodePoint).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("Font", (Object)this.m_aFont).appendIfNotNull("FontResource", (Object)this.m_aFontRes).append("Embed", this.m_bEmbed).append("FallbackCodePoint", this.m_nFallbackCodePoint).getToString();
    }

    @Nonnull
    public static PreloadFont createNonEmbedding(@Nonnull IFontResource iFontResource) {
        ValueEnforcer.notNull((Object)iFontResource, (String)"FontRes");
        try {
            return new PreloadFont(iFontResource, false, 63);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot use the passed font resource " + iFontResource, iOException);
        }
    }

    @Nonnull
    public static PreloadFont createEmbedding(@Nonnull IFontResource iFontResource) {
        ValueEnforcer.notNull((Object)iFontResource, (String)"FontRes");
        try {
            return new PreloadFont(iFontResource, true, 63);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot use the passed font resource " + iFontResource, iOException);
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedMap<String, PDType1Font> getAllStandard14Fonts() {
        return STANDARD_14.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedMap<String, PreloadFont> getAllStandard14PreloadFonts() {
        return STANDARD_14_PF.getClone();
    }
}

