/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.xkcd;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.mapton.addon.xkcd.Xkcd;
import org.mapton.api.MBackgroundImage;
import org.mapton.api.Mapton;

public class XkcdManager {
    private static final String BASE_URL = "https://xkcd.com/";
    private Notifier mDisplayer;
    private int mIndex;
    private String mUrl;

    public static void main(String[] args) throws IOException {
        Xkcd x = new XkcdManager().parse();
        System.out.println(ToStringBuilder.reflectionToString((Object)x, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
    }

    public void setDisplayer(Notifier displayer) {
        this.mDisplayer = displayer;
    }

    void go(Xkcd xkcd) {
        Mapton.getGlobalState().put("background_image", (Object)new MBackgroundImage((Object)xkcd.getSrc(), 0.85));
        this.mDisplayer.onShow(xkcd);
    }

    void goFirst() {
        new Thread(() -> {
            try {
                this.mIndex = 1;
                this.go(this.parse(1));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, this.getClass().getCanonicalName()).start();
    }

    void goLast() {
        new Thread(() -> {
            try {
                this.go(this.parse());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, this.getClass().getCanonicalName()).start();
    }

    void goNext() {
        new Thread(() -> {
            try {
                this.go(this.parse(++this.mIndex));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, this.getClass().getCanonicalName()).start();
    }

    void goPrevious() {
        new Thread(() -> {
            try {
                this.go(this.parse(--this.mIndex));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, this.getClass().getCanonicalName()).start();
    }

    void goRandom() {
        new Thread(() -> {
            try {
                this.go(this.parse("https://c.xkcd.com/random/comic/"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, this.getClass().getCanonicalName()).start();
    }

    private Xkcd parse(int number) throws IOException {
        return this.parse("%s%d".formatted(BASE_URL, number));
    }

    private Xkcd parse(String url) throws IOException {
        Document doc = Jsoup.connect((String)url).get();
        Elements metaTags = doc.getElementsByTag("meta");
        for (Element metaTag : metaTags) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)metaTag.attr("property"), (CharSequence)"og:url")) continue;
            this.mUrl = metaTag.attr("content");
            this.mIndex = Integer.parseInt(this.mUrl.replaceAll("\\D+", ""));
        }
        Element comic = doc.getElementById("comic");
        Element imageElement = comic.select("img").first();
        Xkcd xkcd = new Xkcd();
        xkcd.setAlt(imageElement.attr("alt"));
        xkcd.setFootnote(doc.getElementById("footnote").text());
        xkcd.setLicense(doc.getElementById("licenseText").text());
        xkcd.setSrc(imageElement.absUrl("src"));
        xkcd.setTitle(imageElement.attr("title"));
        xkcd.setUrl(this.mUrl);
        return xkcd;
    }

    private Xkcd parse() throws IOException {
        return this.parse(BASE_URL);
    }

    public static interface Notifier {
        public void onShow(Xkcd var1);
    }
}

