/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.xkcd;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.mapton.addon.xkcd.Bundle;
import org.mapton.addon.xkcd.XkcdManager;
import org.mapton.api.Mapton;
import org.mapton.core.api.MTopComponent;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.fx.control.LogPanel;
import se.trixon.almond.util.icons.material.MaterialIcon;

@TopComponent.Description(preferredID="XkcdTopComponent", persistenceType=0)
public final class XkcdTopComponent
extends MTopComponent {
    private LogPanel mLogPanel;
    private boolean mFirstRun = true;
    private final XkcdManager mManager = new XkcdManager();
    private BorderPane mRoot;

    public XkcdTopComponent() {
        this.setName(Bundle.CTL_XkcdAction());
        this.mManager.setDisplayer(xkcd -> {
            StringBuilder sb = new StringBuilder(xkcd.getAlt()).append("\n\n");
            sb.append(xkcd.getTitle());
            sb.append("\n\n").append(xkcd.getUrl()).append("\n\n");
            sb.append(xkcd.getLicense());
            sb.append("\n\n").append("https://xkcd.com/").append("\n\n");
            this.mLogPanel.setText(sb.toString());
        });
    }

    protected void fxComponentOpened() {
        super.fxComponentOpened();
        if (this.mFirstRun) {
            new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                    this.mManager.goLast();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    Thread.currentThread().interrupt();
                }
            }, ((Object)((Object)this)).getClass().getCanonicalName()).start();
            this.mFirstRun = false;
        }
    }

    protected void initFX() {
        this.setScene(this.createScene());
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    private void clear() {
        this.mLogPanel.clear();
        Mapton.clearBackgroundImage();
    }

    private Scene createScene() {
        Action firstAction = new Action(Dict.FIRST.toString(), event -> {
            this.clear();
            this.mManager.goFirst();
        });
        firstAction.setGraphic((Node)MaterialIcon._Navigation.FIRST_PAGE.getImageView(Mapton.getIconSizeToolBarInt()));
        Action previousAction = new Action(Dict.PREVIOUS.toString(), event -> {
            this.clear();
            this.mManager.goPrevious();
        });
        previousAction.setGraphic((Node)MaterialIcon._Navigation.CHEVRON_LEFT.getImageView(Mapton.getIconSizeToolBarInt()));
        Action nextAction = new Action(Dict.NEXT.toString(), event -> {
            this.clear();
            this.mManager.goNext();
        });
        nextAction.setGraphic((Node)MaterialIcon._Navigation.CHEVRON_RIGHT.getImageView(Mapton.getIconSizeToolBarInt()));
        Action lastAction = new Action(Dict.LAST.toString(), event -> {
            this.clear();
            this.mManager.goLast();
        });
        lastAction.setGraphic((Node)MaterialIcon._Navigation.LAST_PAGE.getImageView(Mapton.getIconSizeToolBarInt()));
        Action randomAction = new Action(Dict.RANDOM.toString(), event -> {
            this.clear();
            this.mManager.goRandom();
        });
        randomAction.setGraphic((Node)MaterialIcon._Places.CASINO.getImageView(Mapton.getIconSizeToolBarInt()));
        Action clearAction = new Action(Dict.CLEAR.toString(), event -> this.clear());
        clearAction.setGraphic((Node)MaterialIcon._Content.CLEAR.getImageView(Mapton.getIconSizeToolBarInt()));
        List<Action> actions = Arrays.asList(firstAction, previousAction, randomAction, nextAction, lastAction, ActionUtils.ACTION_SPAN, clearAction);
        ToolBar toolBar = ActionUtils.createToolBar(actions, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.HIDE);
        FxHelper.adjustButtonWidth((Stream)toolBar.getItems().stream(), (double)Mapton.getIconSizeToolBarInt());
        toolBar.getItems().stream().filter(item -> item instanceof ButtonBase).map(item -> (ButtonBase)item).forEachOrdered(buttonBase -> FxHelper.undecorateButton((ButtonBase)buttonBase));
        FxHelper.slimToolBar((ToolBar)toolBar);
        Label titleLabel = Mapton.createTitle((String)Bundle.CTL_XkcdAction());
        this.mLogPanel = new LogPanel();
        this.mLogPanel.setMonospaced();
        this.mLogPanel.setWrapText(true);
        BorderPane innerPane = new BorderPane((Node)toolBar);
        this.mRoot = new BorderPane((Node)this.mLogPanel);
        innerPane.setTop((Node)titleLabel);
        this.mRoot.setTop((Node)innerPane);
        titleLabel.prefWidthProperty().bind((ObservableValue)this.mRoot.widthProperty());
        return new Scene((Parent)this.mRoot);
    }
}

