/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRDoubleIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRIncrementer;

class JRDoubleSumIncrementer
implements JRIncrementer {
    private static JRDoubleSumIncrementer mainInstance = new JRDoubleSumIncrementer();

    private JRDoubleSumIncrementer() {
    }

    public static JRDoubleSumIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRFillVariable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        Number newValue = (Number)expressionValue;
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            value = JRDoubleIncrementerFactory.ZERO;
        }
        return new Double(value.doubleValue() + newValue.doubleValue());
    }
}

